/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.geometry.transformations;

import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.geometry.transformations.AtlantisToWGS84;
import org.matsim.core.utils.geometry.transformations.CH1903LV03PlustoWGS84;
import org.matsim.core.utils.geometry.transformations.CH1903LV03toWGS84;
import org.matsim.core.utils.geometry.transformations.GK4toWGS84;
import org.matsim.core.utils.geometry.transformations.GeotoolsTransformation;
import org.matsim.core.utils.geometry.transformations.IdentityTransformation;
import org.matsim.core.utils.geometry.transformations.WGS84toAtlantis;
import org.matsim.core.utils.geometry.transformations.WGS84toCH1903LV03;
import org.matsim.core.utils.geometry.transformations.WGS84toCH1903LV03Plus;

public abstract class TransformationFactory {
    public static final String WGS84 = "WGS84";
    public static final String ATLANTIS = "Atlantis";
    public static final String CH1903_LV03 = "CH1903_LV03";
    public static final String CH1903_LV03_Plus = "CH1903_LV03_Plus";
    public static final String GK4 = "GK4";
    public static final String WGS84_UTM47S = "WGS84_UTM47S";
    public static final String WGS84_UTM48N = "WGS84_UTM48N";
    public static final String WGS84_UTM35S = "WGS84_UTM35S";
    public static final String WGS84_UTM36S = "WGS84_UTM36S";
    public static final String WGS84_Albers = "WGS84_Albers";
    public static final String WGS84_SA_Albers = "WGS84_SA_Albers";
    public static final String HARTEBEESTHOEK94_LO19 = "SA_Lo19";
    public static final String HARTEBEESTHOEK94_LO29 = "SA_Lo29";
    public static final String HARTEBEESTHOEK94_LO31 = "SA_Lo31";
    public static final String WGS84_UTM33N = "WGS84_UTM33N";
    public static final String DHDN_GK4 = "DHDN_GK4";
    public static final String WGS84_UTM29N = "WGS84_UTM29N";
    public static final String WGS84_UTM31N = "WGS84_UTM31N";
    public static final String CH1903_LV03_GT = "CH1903_LV03_GT";
    public static final String CH1903_LV03_Plus_GT = "CH1903_LV03_Plus_GT";
    public static final String WGS84_SVY21 = "WGS84_SVY21";
    public static final String NAD83_UTM17N = "NAD83_UTM17N";
    public static final String WGS84_TM = "WGS84_TM";
    public static final String PCS_ITRF2000_TM_UOS = "PCS_ITRF2000_TM_UOS";
    public static final String DHDN_SoldnerBerlin = "DHDN_SoldnerBerlin";

    public static CoordinateTransformation getCoordinateTransformation(String fromSystem, String toSystem) {
        if (fromSystem.equals(toSystem)) {
            return new IdentityTransformation();
        }
        if (WGS84.equals(fromSystem)) {
            if (CH1903_LV03.equals(toSystem)) {
                return new WGS84toCH1903LV03();
            }
            if (CH1903_LV03_Plus.equals(toSystem)) {
                return new WGS84toCH1903LV03Plus();
            }
            if (ATLANTIS.equals(toSystem)) {
                return new WGS84toAtlantis();
            }
        }
        if (WGS84.equals(toSystem)) {
            if (CH1903_LV03.equals(fromSystem)) {
                return new CH1903LV03toWGS84();
            }
            if (CH1903_LV03_Plus.equals(fromSystem)) {
                return new CH1903LV03PlustoWGS84();
            }
            if (GK4.equals(fromSystem)) {
                return new GK4toWGS84();
            }
            if (ATLANTIS.equals(fromSystem)) {
                return new AtlantisToWGS84();
            }
        }
        return new GeotoolsTransformation(fromSystem, toSystem);
    }
}

