/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.geometry.transformations;

import org.matsim.api.core.v01.Coord;
import org.matsim.core.utils.geometry.CoordinateTransformation;

public class WGS84toCH1903LV03Plus
implements CoordinateTransformation {
    @Override
    public Coord transform(Coord coord) {
        double lonNorm = (coord.getX() * 3600.0 - 26782.5) / 10000.0;
        double latNorm = (coord.getY() * 3600.0 - 169028.66) / 10000.0;
        double CH1903X = 1200147.07 + 308807.95 * latNorm + 3745.25 * Math.pow(lonNorm, 2.0) + 76.63 * Math.pow(latNorm, 2.0) - 194.56 * Math.pow(lonNorm, 2.0) * latNorm + 119.79 * Math.pow(latNorm, 3.0);
        double CH1903Y = 2600072.37 + 211455.93 * lonNorm - 10938.51 * lonNorm * latNorm - 0.36 * lonNorm * Math.pow(latNorm, 2.0) - 44.54 * Math.pow(lonNorm, 3.0);
        try {
            double elevation = coord.getZ();
            return new Coord(Math.round(CH1903Y), Math.round(CH1903X), elevation);
        }
        catch (Exception e) {
            return new Coord(Math.round(CH1903Y), Math.round(CH1903X));
        }
    }
}

