/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.gis;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.matsim.api.core.v01.Coord;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PointFeatureFactory {
    private final Map<String, Class<?>> attributes;
    private final SimpleFeatureType featureType;
    private final GeometryFactory fac = new GeometryFactory();
    private final SimpleFeatureBuilder builder;

    private PointFeatureFactory(Map<String, Class<?>> attributes, SimpleFeatureType featureType) {
        this.attributes = attributes;
        this.featureType = featureType;
        this.builder = new SimpleFeatureBuilder(this.featureType);
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public SimpleFeature createPoint(Coordinate coordinate) {
        return this.createPoint(coordinate, Collections.emptyMap(), null);
    }

    public SimpleFeature createPoint(Coordinate coordinate, Map<String, Object> attributeValues, String id) {
        Point p = this.fac.createPoint(coordinate);
        this.builder.add(p);
        for (String name : this.attributes.keySet()) {
            Object value = attributeValues.get(name);
            this.builder.add(value);
        }
        return this.builder.buildFeature(id);
    }

    public SimpleFeature createPoint(Coordinate coordinate, Object[] attributeValues, String id) {
        Point p = this.fac.createPoint(coordinate);
        return this.createPoint(p, attributeValues, id);
    }

    public SimpleFeature createPoint(Point point, Object[] attributeValues, String id) {
        this.builder.add(point);
        for (int i = 0; i < attributeValues.length; ++i) {
            Object value = attributeValues[i];
            this.builder.add(value);
        }
        return this.builder.buildFeature(id);
    }

    public SimpleFeature createPoint(Coord coordinate, Object[] attributeValues, String id) {
        Point p = this.fac.createPoint(new Coordinate(coordinate.getX(), coordinate.getY()));
        this.builder.add(p);
        for (int i = 0; i < attributeValues.length; ++i) {
            Object value = attributeValues[i];
            this.builder.add(value);
        }
        return this.builder.buildFeature(id);
    }

    public static class Builder {
        private CoordinateReferenceSystem crs = null;
        private String name = "";
        private Map<String, Class<?>> attributes = new LinkedHashMap();

        public Builder setCrs(CoordinateReferenceSystem crs) {
            this.crs = crs;
            return this;
        }

        public Builder addAttribute(String name, Class<?> type) {
            this.attributes.put(name, type);
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public PointFeatureFactory create() {
            SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
            b.setName(this.name);
            b.setCRS(this.crs);
            b.add("the_geom", Point.class);
            for (Map.Entry<String, Class<?>> attr : this.attributes.entrySet()) {
                b.add(attr.getKey(), attr.getValue());
            }
            SimpleFeatureType featureType = b.buildFeatureType();
            return new PointFeatureFactory(this.attributes, featureType);
        }
    }
}

