/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.gis;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.matsim.api.core.v01.Coord;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PolygonFeatureFactory {
    private final Map<String, Class<?>> attributes;
    private final SimpleFeatureType featureType;
    private final GeometryFactory fac = new GeometryFactory();
    private final SimpleFeatureBuilder builder;

    private PolygonFeatureFactory(Map<String, Class<?>> attributes, SimpleFeatureType featureType) {
        this.attributes = attributes;
        this.featureType = featureType;
        this.builder = new SimpleFeatureBuilder(this.featureType);
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public SimpleFeature createPolygon(Coordinate[] coordinates) {
        return this.createPolygon(coordinates, Collections.emptyMap(), null);
    }

    public SimpleFeature createPolygon(Coord[] coordinates) {
        Coordinate[] coords = new Coordinate[coordinates.length];
        for (int i = 0; i < coordinates.length; ++i) {
            coords[i] = new Coordinate(coordinates[i].getX(), coordinates[i].getY());
        }
        return this.createPolygon(coords, Collections.emptyMap(), null);
    }

    public SimpleFeature createPolygon(Coordinate[] coordinates, Map<String, Object> attributeValues, String id) {
        LinearRing shell;
        if (coordinates[0] == coordinates[coordinates.length - 1]) {
            shell = this.fac.createLinearRing(coordinates);
        } else {
            Coordinate[] coordinates2 = new Coordinate[coordinates.length + 1];
            System.arraycopy(coordinates, 0, coordinates2, 0, coordinates.length);
            coordinates2[coordinates.length] = coordinates[0];
            shell = this.fac.createLinearRing(coordinates2);
        }
        Polygon p = this.fac.createPolygon(shell, null);
        MultiPolygon mp = this.fac.createMultiPolygon(new Polygon[]{p});
        return this.createPolygon(mp, attributeValues, id);
    }

    public SimpleFeature createPolygon(Polygon polygon, Map<String, Object> attributeValues, String id) {
        MultiPolygon mp = this.fac.createMultiPolygon(new Polygon[]{polygon});
        return this.createPolygon(mp, attributeValues, id);
    }

    public SimpleFeature createPolygon(MultiPolygon polygon, Map<String, Object> attributeValues, String id) {
        this.builder.add(polygon);
        for (String name : this.attributes.keySet()) {
            Object value = attributeValues.get(name);
            this.builder.add(value);
        }
        return this.builder.buildFeature(id);
    }

    public SimpleFeature createPolygon(Coordinate[] coordinates, Object[] attributeValues, String id) {
        LinearRing shell;
        if (coordinates[0] == coordinates[coordinates.length - 1]) {
            shell = this.fac.createLinearRing(coordinates);
        } else {
            Coordinate[] coordinates2 = new Coordinate[coordinates.length + 1];
            System.arraycopy(coordinates, 0, coordinates2, 0, coordinates.length);
            coordinates2[coordinates.length] = coordinates[0];
            shell = this.fac.createLinearRing(coordinates2);
        }
        Polygon p = this.fac.createPolygon(shell, null);
        MultiPolygon mp = this.fac.createMultiPolygon(new Polygon[]{p});
        return this.createPolygon(mp, attributeValues, id);
    }

    public SimpleFeature createPolygon(Polygon polygon, Object[] attributeValues, String id) {
        MultiPolygon mp = this.fac.createMultiPolygon(new Polygon[]{polygon});
        return this.createPolygon(mp, attributeValues, id);
    }

    public SimpleFeature createPolygon(MultiPolygon polygon, Object[] attributeValues, String id) {
        this.builder.add(polygon);
        for (int i = 0; i < attributeValues.length; ++i) {
            Object value = attributeValues[i];
            this.builder.add(value);
        }
        return this.builder.buildFeature(id);
    }

    public static class Builder {
        private CoordinateReferenceSystem crs = null;
        private String name = "";
        private Map<String, Class<?>> attributes = new LinkedHashMap();

        public Builder setCrs(CoordinateReferenceSystem crs) {
            this.crs = crs;
            return this;
        }

        public Builder addAttribute(String name, Class<?> type) {
            this.attributes.put(name, type);
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public PolygonFeatureFactory create() {
            SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
            b.setName(this.name);
            b.setCRS(this.crs);
            b.add("the_geom", MultiPolygon.class);
            for (Map.Entry<String, Class<?>> attr : this.attributes.entrySet()) {
                b.add(attr.getKey(), attr.getValue());
            }
            SimpleFeatureType featureType = b.buildFeatureType();
            return new PolygonFeatureFactory(this.attributes, featureType);
        }
    }
}

