/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.gis;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PolylineFeatureFactory {
    private final Map<String, Class<?>> attributes;
    private final SimpleFeatureType featureType;
    private final GeometryFactory fac = new GeometryFactory();
    private final SimpleFeatureBuilder builder;

    private PolylineFeatureFactory(Map<String, Class<?>> attributes, SimpleFeatureType featureType) {
        this.attributes = attributes;
        this.featureType = featureType;
        this.builder = new SimpleFeatureBuilder(this.featureType);
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public SimpleFeature createPolyline(Coordinate[] coordinates) {
        return this.createPolyline(coordinates, Collections.emptyMap(), null);
    }

    public SimpleFeature createPolyline(Coordinate[] coordinates, Map<String, Object> attributeValues, String id) {
        LineString ls = this.fac.createLineString(coordinates);
        MultiLineString mls = this.fac.createMultiLineString(new LineString[]{ls});
        this.builder.add(mls);
        for (String name : this.attributes.keySet()) {
            Object value = attributeValues.get(name);
            this.builder.add(value);
        }
        return this.builder.buildFeature(id);
    }

    public SimpleFeature createPolyline(Coordinate[] coordinates, Object[] attributeValues, String id) {
        LineString ls = this.fac.createLineString(coordinates);
        return this.createPolyline(ls, attributeValues, id);
    }

    public SimpleFeature createPolyline(LineString lineString, Object[] attributeValues, String id) {
        MultiLineString mls = this.fac.createMultiLineString(new LineString[]{lineString});
        return this.createPolyline(mls, attributeValues, id);
    }

    public SimpleFeature createPolyline(MultiLineString multiLineString, Object[] attributeValues, String id) {
        this.builder.add(multiLineString);
        for (Object value : attributeValues) {
            this.builder.add(value);
        }
        return this.builder.buildFeature(id);
    }

    public static class Builder {
        private CoordinateReferenceSystem crs = null;
        private String name = "";
        private Map<String, Class<?>> attributes = new LinkedHashMap();

        public Builder setCrs(CoordinateReferenceSystem crs) {
            this.crs = crs;
            return this;
        }

        public Builder addAttribute(String name, Class<?> type) {
            this.attributes.put(name, type);
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public PolylineFeatureFactory create() {
            SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
            b.setName(this.name);
            b.setCRS(this.crs);
            b.add("the_geom", MultiLineString.class);
            for (Map.Entry<String, Class<?>> attr : this.attributes.entrySet()) {
                b.add(attr.getKey(), attr.getValue());
            }
            SimpleFeatureType featureType = b.buildFeatureType();
            return new PolylineFeatureFactory(this.attributes, featureType);
        }
    }
}

