/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.gis;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.geotools.data.DataStore;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.matsim.core.api.internal.MatsimSomeReader;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.utils.io.UncheckedIOException;
import org.matsim.core.utils.misc.Counter;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ShapeFileReader
implements MatsimSomeReader {
    private static final Logger log = Logger.getLogger(ShapeFileReader.class);
    private SimpleFeatureSource featureSource = null;
    private ReferencedEnvelope bounds = null;
    private DataStore dataStore = null;
    private SimpleFeatureCollection featureCollection = null;
    private SimpleFeatureType schema = null;
    private Collection<SimpleFeature> featureSet = null;
    private CoordinateReferenceSystem crs;

    public static Collection<SimpleFeature> getAllFeatures(String filename) {
        try {
            File dataFile = new File(filename);
            log.info("will try to read from " + dataFile.getAbsolutePath());
            Gbl.assertIf(dataFile.exists());
            FileDataStore store = FileDataStoreFinder.getDataStore(dataFile);
            SimpleFeatureSource featureSource = store.getFeatureSource();
            SimpleFeatureIterator it = featureSource.getFeatures().features();
            ArrayList<SimpleFeature> featureSet = new ArrayList<SimpleFeature>();
            while (it.hasNext()) {
                SimpleFeature ft = (SimpleFeature)it.next();
                featureSet.add(ft);
            }
            it.close();
            store.dispose();
            return featureSet;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Collection<SimpleFeature> getAllFeatures(URL url) {
        try {
            log.info("will try to read from " + url.getPath());
            FileDataStore store = FileDataStoreFinder.getDataStore(url);
            SimpleFeatureSource featureSource = store.getFeatureSource();
            SimpleFeatureIterator it = featureSource.getFeatures().features();
            ArrayList<SimpleFeature> featureSet = new ArrayList<SimpleFeature>();
            while (it.hasNext()) {
                SimpleFeature ft = (SimpleFeature)it.next();
                featureSet.add(ft);
            }
            it.close();
            store.dispose();
            return featureSet;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Collection<SimpleFeature> readFileAndInitialize(String filename) throws UncheckedIOException {
        try {
            this.featureSource = ShapeFileReader.readDataFile(filename);
            this.init();
            SimpleFeature ft = null;
            SimpleFeatureIterator it = this.featureSource.getFeatures().features();
            this.featureSet = new ArrayList<SimpleFeature>();
            log.info("features to read #" + this.featureSource.getFeatures().size());
            Counter cnt = new Counter("features read #");
            while (it.hasNext()) {
                ft = (SimpleFeature)it.next();
                this.featureSet.add(ft);
                cnt.incCounter();
            }
            cnt.printCounter();
            it.close();
            return this.featureSet;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static SimpleFeatureSource readDataFile(String filename) throws UncheckedIOException {
        try {
            log.warn("Unsafe method! store.dispose() is not called from within this method");
            File dataFile = new File(filename);
            FileDataStore store = FileDataStoreFinder.getDataStore(dataFile);
            return store.getFeatureSource();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void init() {
        try {
            this.bounds = this.featureSource.getBounds();
            this.dataStore = (DataStore)this.featureSource.getDataStore();
            this.featureCollection = this.featureSource.getFeatures();
            this.schema = (SimpleFeatureType)this.featureSource.getSchema();
            this.crs = ((SimpleFeatureType)this.featureSource.getSchema()).getCoordinateReferenceSystem();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public SimpleFeatureSource getFeatureSource() {
        return this.featureSource;
    }

    public ReferencedEnvelope getBounds() {
        return this.bounds;
    }

    public DataStore getDataStore() {
        return this.dataStore;
    }

    public SimpleFeatureCollection getFeatureCollection() {
        return this.featureCollection;
    }

    public SimpleFeatureType getSchema() {
        return this.schema;
    }

    public Collection<SimpleFeature> getFeatureSet() {
        return this.featureSet;
    }

    public CoordinateReferenceSystem getCoordinateSystem() {
        return this.crs;
    }
}

