/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.gis;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.feature.DefaultFeatureCollection;
import org.matsim.core.api.internal.MatsimSomeWriter;
import org.matsim.core.utils.io.UncheckedIOException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class ShapeFileWriter
implements MatsimSomeWriter {
    private static final Logger log = Logger.getLogger(ShapeFileWriter.class);

    public static void writeGeometries(Collection<SimpleFeature> features, String filename) {
        if (features.isEmpty()) {
            throw new UncheckedIOException("Cannot write empty collection");
        }
        log.info("Writing shapefile to " + filename);
        try {
            URL fileURL = new File(filename).toURI().toURL();
            ShapefileDataStore datastore = new ShapefileDataStore(fileURL);
            SimpleFeature feature = features.iterator().next();
            datastore.createSchema(feature.getFeatureType());
            DefaultFeatureCollection coll = new DefaultFeatureCollection();
            coll.addAll((Collection<? extends SimpleFeature>)features);
            SimpleFeatureType featureType = features.iterator().next().getFeatureType();
            datastore.createSchema(featureType);
            SimpleFeatureStore featureSource = (SimpleFeatureStore)((Object)datastore.getFeatureSource());
            featureSource.addFeatures(coll);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

