/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPOutputStream;
import org.matsim.core.utils.io.IOUtils;
import org.matsim.core.utils.io.UncheckedIOException;

public abstract class AbstractMatsimWriter {
    protected static final String NL = "\n";
    protected BufferedWriter writer = null;
    protected Boolean useCompression = null;

    public final void useCompression(boolean useCompression) {
        this.useCompression = useCompression;
    }

    protected final void openFile(String filename) throws UncheckedIOException {
        this.assertNotAlreadyOpen();
        this.writer = this.useCompression == null ? IOUtils.getBufferedWriter(filename) : IOUtils.getBufferedWriter(filename, this.useCompression);
    }

    protected final void openOutputStream(OutputStream outputStream) {
        this.assertNotAlreadyOpen();
        try {
            this.writer = this.useCompression == null || this.useCompression.booleanValue() ? new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8)) : new BufferedWriter(new OutputStreamWriter((OutputStream)new GZIPOutputStream(outputStream), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void assertNotAlreadyOpen() {
        if (this.writer != null) {
            throw new RuntimeException("File already open.");
        }
    }

    protected final void close() throws UncheckedIOException {
        if (this.writer != null) {
            try {
                this.writer.flush();
                this.writer.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                this.writer = null;
            }
        }
    }
}

