/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;
import org.apache.log4j.Logger;
import org.matsim.core.utils.io.UncheckedIOException;
import org.matsim.core.utils.io.UnicodeInputStream;

public class IOUtils {
    private static final String GZ = ".gz";
    private static final String LZ4 = ".lz4";
    public static final Charset CHARSET_UTF8 = StandardCharsets.UTF_8;
    public static final Charset CHARSET_WINDOWS_ISO88591 = StandardCharsets.ISO_8859_1;
    public static final String NATIVE_NEWLINE = System.getProperty("line.separator");
    private static final Logger log = Logger.getLogger(IOUtils.class);

    public static URL getUrlFromFileOrResource(String filename) {
        File file;
        if (filename.startsWith("~" + File.separator)) {
            filename = System.getProperty("user.home") + filename.substring(1);
        }
        if ((file = new File(filename)).exists()) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        log.info("String " + filename + " does not exist as file on the file system; trying it as a resource ...");
        URL resourceAsStream = IOUtils.class.getClassLoader().getResource(filename);
        if (resourceAsStream == null) {
            throw new RuntimeException("Filename |" + filename + "| not found.");
        }
        return resourceAsStream;
    }

    public static BufferedReader getBufferedReader(String filename) throws UncheckedIOException {
        return IOUtils.getBufferedReader(filename, StandardCharsets.UTF_8);
    }

    public static BufferedReader getBufferedReader(URL url) throws UncheckedIOException {
        return IOUtils.getBufferedReader(url, StandardCharsets.UTF_8);
    }

    public static BufferedReader getBufferedReader(String filename, Charset charset) throws UncheckedIOException {
        BufferedReader infile = null;
        if (filename == null) {
            throw new UncheckedIOException(new FileNotFoundException("No filename given (filename == null)"));
        }
        try {
            infile = new BufferedReader(new InputStreamReader(IOUtils.getInputStream(filename), charset));
        }
        catch (UncheckedIOException e) {
            log.fatal("encountered IOException.  This will most probably be fatal.  Note that for relative path names, the root is no longer the Java root, but the directory where the config file resides.");
            throw new UncheckedIOException(e);
        }
        return infile;
    }

    public static BufferedReader getBufferedReader(URL url, Charset charset) throws UncheckedIOException {
        BufferedReader infile = null;
        if (url == null) {
            throw new UncheckedIOException(new FileNotFoundException("No url given (url == null)"));
        }
        try {
            infile = new BufferedReader(new InputStreamReader(IOUtils.getInputStream(url), charset));
        }
        catch (UncheckedIOException e) {
            log.fatal("encountered IOException.  This will most probably be fatal.  Note that for relative path names, the root is no longer the Java root, but the directory where the config file resides.");
            throw new UncheckedIOException(e);
        }
        return infile;
    }

    public static BufferedWriter getBufferedWriter(String filename, boolean useCompression) throws UncheckedIOException {
        if (filename == null) {
            throw new UncheckedIOException(new FileNotFoundException("No filename given (filename == null)"));
        }
        if (useCompression && !filename.endsWith(GZ)) {
            return IOUtils.getBufferedWriter(filename + GZ);
        }
        if (!useCompression && filename.endsWith(GZ)) {
            return IOUtils.getBufferedWriter(filename.substring(0, filename.length() - 3));
        }
        return IOUtils.getBufferedWriter(filename);
    }

    public static BufferedWriter getBufferedWriter(String filename) throws UncheckedIOException {
        return IOUtils.getBufferedWriter(filename, Charset.forName("UTF8"));
    }

    public static BufferedWriter getAppendingBufferedWriter(String filename) throws UncheckedIOException {
        return IOUtils.getBufferedWriter(filename, Charset.forName("UTF8"), true);
    }

    public static BufferedWriter getBufferedWriter(String filename, Charset charset) throws UncheckedIOException {
        return IOUtils.getBufferedWriter(filename, charset, false);
    }

    public static BufferedWriter getAppendingBufferedWriter(String filename, Charset charset) throws UncheckedIOException {
        return IOUtils.getBufferedWriter(filename, charset, true);
    }

    public static BufferedWriter getBufferedWriter(String filename, Charset charset, boolean append) throws UncheckedIOException {
        if (filename == null) {
            throw new UncheckedIOException(new FileNotFoundException("No filename given (filename == null)"));
        }
        try {
            return new BufferedWriter(new OutputStreamWriter(IOUtils.getOutputStream(filename, append), charset));
        }
        catch (UncheckedIOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void copyStream(InputStream fromStream, OutputStream toStream) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[4096];
        while ((bytesRead = fromStream.read(buffer)) != -1) {
            toStream.write(buffer, 0, bytesRead);
        }
    }

    public static void deleteDirectoryRecursively(Path path) throws UncheckedIOException {
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
    }

    public static InputStream getInputStream(String filename) throws UncheckedIOException {
        InputStream inputStream = null;
        if (filename == null) {
            throw new UncheckedIOException(new FileNotFoundException("No filename given (filename == null)"));
        }
        try {
            if (new File(filename).exists()) {
                inputStream = filename.endsWith(GZ) ? new GZIPInputStream(new FileInputStream(filename)) : (filename.endsWith(LZ4) ? new UnicodeInputStream(new LZ4BlockInputStream(new FileInputStream(filename))) : new FileInputStream(filename));
            } else if (new File(filename + GZ).exists()) {
                inputStream = new GZIPInputStream(new FileInputStream(filename + GZ));
            } else {
                InputStream stream = IOUtils.class.getClassLoader().getResourceAsStream(filename);
                if (stream != null) {
                    inputStream = filename.endsWith(GZ) ? new GZIPInputStream(stream) : stream;
                } else {
                    stream = IOUtils.class.getClassLoader().getResourceAsStream(filename + GZ);
                    if (stream != null) {
                        inputStream = new GZIPInputStream(stream);
                    }
                }
                if (inputStream != null) {
                    log.info("streaming file from classpath: " + filename);
                }
            }
            if (inputStream == null) {
                throw new FileNotFoundException(filename);
            }
            return new BufferedInputStream(new UnicodeInputStream(inputStream));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static InputStream getInputStream(URL url) throws UncheckedIOException {
        try {
            if (url.getFile().endsWith(GZ)) {
                return new GZIPInputStream(url.openStream());
            }
            return url.openStream();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static OutputStream getOutputStream(String filename) throws UncheckedIOException {
        return IOUtils.getOutputStream(filename, false);
    }

    public static OutputStream getOutputStream(String filename, boolean append) throws UncheckedIOException {
        if (filename == null) {
            throw new UncheckedIOException(new FileNotFoundException("No filename given (filename == null)"));
        }
        try {
            if (filename.toLowerCase(Locale.ROOT).endsWith(GZ)) {
                File f = new File(filename);
                if (append && f.exists() && f.length() > 0L) {
                    throw new IllegalArgumentException("Appending to an existing gzip-compressed file is not supported.");
                }
                return new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(filename, append)));
            }
            if (filename.toLowerCase(Locale.ROOT).endsWith(LZ4)) {
                File f = new File(filename);
                if (append && f.exists() && f.length() > 0L) {
                    throw new IllegalArgumentException("Appending to an existing lz4-compressed file is not supported.");
                }
                return new BufferedOutputStream(new LZ4BlockOutputStream(new FileOutputStream(filename)));
            }
            return new BufferedOutputStream(new FileOutputStream(filename, append));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static PrintStream getPrintStream(String filename) {
        if (filename == null) {
            throw new UncheckedIOException(new FileNotFoundException("No filename given (filename == null)"));
        }
        try {
            if (filename.toLowerCase(Locale.ROOT).endsWith(GZ)) {
                return new PrintStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(filename))));
            }
            return new PrintStream(new BufferedOutputStream(new FileOutputStream(filename)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static boolean isEqual(InputStream i1, InputStream i2) throws IOException {
        try {
            while (true) {
                int tr;
                int fr;
                if ((fr = i1.read()) != (tr = i2.read())) {
                    boolean bl = false;
                    return bl;
                }
                if (fr != -1) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (i1 != null) {
                i1.close();
            }
            if (i2 != null) {
                i2.close();
            }
        }
    }

    public static URL newUrl(URL context, String spec) {
        try {
            return new URL(context, spec);
        }
        catch (MalformedURLException e) {
            try {
                return new File(spec).toURI().toURL();
            }
            catch (MalformedURLException e1) {
                throw new RuntimeException(e1);
            }
        }
    }
}

