/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.io;

import java.io.IOException;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.matsim.core.utils.io.IOUtils;
import org.matsim.core.utils.io.UncheckedIOException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class MatsimFileTypeGuesser
extends DefaultHandler {
    private static final Logger log = Logger.getLogger(MatsimFileTypeGuesser.class);
    public static final String SYSTEMIDNOTFOUNDMESSAGE = "System Id of xml document couldn't be detected. Make sure that you try to read a xml document with a valid header. If your header seems to be ok, make shure that there is no / at the end of the first part of the tuple used as value for xsi:schemaLocation.";
    private FileType fileType = null;
    private String xmlPublicId = null;
    private String xmlSystemId = null;

    public MatsimFileTypeGuesser(String fileName) throws UncheckedIOException {
        String name = fileName.toLowerCase(Locale.ROOT);
        if (name.endsWith(".xml.gz") || name.endsWith(".xml")) {
            this.guessFileTypeXml(fileName);
            String shortSystemId = null;
            if (this.xmlSystemId != null) {
                shortSystemId = this.xmlSystemId.substring(this.xmlSystemId.replace('\\', '/').lastIndexOf(47) + 1);
            }
            if (shortSystemId != null) {
                if (shortSystemId.startsWith("network_")) {
                    this.fileType = FileType.Network;
                } else if (shortSystemId.startsWith("world_")) {
                    this.fileType = FileType.World;
                } else if (shortSystemId.startsWith("plans_")) {
                    this.fileType = FileType.Population;
                } else if (shortSystemId.startsWith("population_")) {
                    this.fileType = FileType.Population;
                } else if (shortSystemId.startsWith("facilities_")) {
                    this.fileType = FileType.Facilities;
                } else if (shortSystemId.startsWith("config_")) {
                    this.fileType = FileType.Config;
                } else if (shortSystemId.startsWith("counts_")) {
                    this.fileType = FileType.Counts;
                } else if (shortSystemId.startsWith("vehicleDefinitions_")) {
                    this.fileType = FileType.Vehicles;
                } else if (shortSystemId.startsWith("transitSchedule_")) {
                    this.fileType = FileType.TransitSchedule;
                } else if (shortSystemId.startsWith("objectattributes_")) {
                    this.fileType = FileType.ObjectAttributes;
                }
            }
        } else if (name.endsWith(".txt.gz") || name.endsWith(".txt")) {
            this.fileType = FileType.Events;
        } else if (name.endsWith(".mvi.gz") || name.endsWith(".mvi")) {
            this.fileType = FileType.OTFVis;
        } else if (name.endsWith(".veh.gz") || name.endsWith(".veh")) {
            this.fileType = FileType.TransimsVehicle;
        }
    }

    public FileType getGuessedFileType() {
        return this.fileType;
    }

    public String getPublicId() {
        return this.xmlPublicId;
    }

    public String getSystemId() {
        return this.xmlSystemId;
    }

    private void guessFileTypeXml(String fileName) throws UncheckedIOException {
        block13: {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            try {
                XmlHandler handler = new XmlHandler();
                InputSource input = new InputSource(IOUtils.getBufferedReader(fileName));
                factory.setFeature("http://apache.org/xml/features/validation/schema", true);
                SAXParser parser = factory.newSAXParser();
                XMLReader reader = parser.getXMLReader();
                reader.setContentHandler(handler);
                reader.setErrorHandler(handler);
                reader.setEntityResolver(handler);
                reader.parse(input);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (SAXException e) {
                throw new UncheckedIOException(e);
            }
            catch (ParserConfigurationException e) {
                throw new UncheckedIOException(e);
            }
            catch (XMLTypeDetectionException e) {
                this.xmlPublicId = e.publicId;
                this.xmlSystemId = e.systemId;
                log.debug("Detected public id: " + this.xmlPublicId);
                log.debug("Detected system Id: " + this.xmlSystemId);
                if (e.rootTag == null) break block13;
                log.debug("Detected root tag: " + e.rootTag);
                if ("events".equals(e.rootTag)) {
                    this.fileType = FileType.Events;
                }
                if ("signalGroups".equals(e.rootTag)) {
                    this.fileType = FileType.SignalGroups;
                }
                if ("signalSystems".equals(e.rootTag)) {
                    this.fileType = FileType.SignalSystems;
                }
                if ("signalControl".equals(e.rootTag)) {
                    this.fileType = FileType.SignalControl;
                }
                if ("laneDefinitions".equals(e.rootTag)) {
                    this.fileType = FileType.LaneDefinitions;
                }
                if ("counts".equals(e.rootTag)) {
                    this.fileType = FileType.Counts;
                }
                if ("transitSchedule".equals(e.rootTag)) {
                    this.fileType = FileType.TransitSchedule;
                }
                if ("objectAttributes".equals(e.rootTag)) {
                    this.fileType = FileType.ObjectAttributes;
                }
                log.warn("got unexpected rootTag: " + e.rootTag);
            }
        }
    }

    private static final class XMLTypeDetectionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        public final String publicId;
        public final String systemId;
        public String rootTag;

        public XMLTypeDetectionException(String publicId, String systemId) {
            this.publicId = publicId;
            this.systemId = systemId;
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    private static final class XmlHandler
    extends DefaultHandler {
        private XMLTypeDetectionException exception;
        private boolean detectedFirstEntity = false;

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            if (!this.detectedFirstEntity) {
                this.exception = new XMLTypeDetectionException(publicId, systemId);
                this.detectedFirstEntity = true;
            }
            if (systemId.endsWith(".dtd")) {
                throw this.exception;
            }
            return null;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            String tag;
            String string = tag = uri.length() == 0 ? qName : localName;
            if (this.exception == null) {
                this.exception = new XMLTypeDetectionException(null, null);
            }
            this.exception.rootTag = tag;
            throw this.exception;
        }
    }

    public static enum FileType {
        Config,
        Network,
        Facilities,
        Population,
        World,
        Counts,
        Events,
        Households,
        TransimsVehicle,
        OTFVis,
        SignalSystems,
        LaneDefinitions,
        SignalGroups,
        SignalControl,
        AmberTimes,
        TransitSchedule,
        Vehicles,
        ObjectAttributes;

    }
}

