/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Stack;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.matsim.core.api.internal.MatsimReader;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.utils.io.IOUtils;
import org.matsim.core.utils.io.UncheckedIOException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class MatsimXmlParser
extends DefaultHandler
implements MatsimReader {
    private static final Logger log = Logger.getLogger(MatsimXmlParser.class);
    private final Stack<StringBuffer> buffers = new Stack();
    private final Stack<String> theContext = new Stack();
    private boolean isValidating = true;
    private boolean isNamespaceAware = true;
    private String localDtdBase = null;
    private boolean preferLocalDtds = false;
    private String doctype = null;
    private String theSource;

    public MatsimXmlParser() {
        String localDtd = System.getProperty("matsim.preferLocalDtds");
        if (localDtd != null) {
            this.preferLocalDtds = Boolean.parseBoolean(localDtd);
        }
    }

    public abstract void startTag(String var1, Attributes var2, Stack<String> var3);

    public abstract void endTag(String var1, String var2, Stack<String> var3);

    public final void setValidating(boolean validateXml) {
        this.isValidating = validateXml;
    }

    public final void setNamespaceAware(boolean awareness) {
        this.isNamespaceAware = awareness;
    }

    public final void setLocalDtdDirectory(String localDtdDirectory) {
        this.localDtdBase = localDtdDirectory;
    }

    @Override
    public final void readFile(String filename) throws UncheckedIOException {
        log.info("starting to parse xml from file " + filename + " ...");
        this.theSource = filename;
        this.parse(new InputSource(IOUtils.getBufferedReader(filename)));
    }

    @Override
    public final void readURL(URL url) throws UncheckedIOException {
        this.parse(url);
    }

    public final void parse(URL url) throws UncheckedIOException {
        Gbl.assertNotNull(url);
        this.theSource = url.toString();
        log.info("starting to parse xml from url " + this.theSource + " ...");
        System.out.flush();
        if (url.getFile().endsWith(".gz")) {
            try {
                this.parse(new InputSource(new GZIPInputStream(url.openStream())));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.parse(new InputSource(url.toExternalForm()));
        }
    }

    public final void parse(InputStream stream) throws UncheckedIOException {
        this.theSource = "stream";
        this.parse(new InputSource(stream));
    }

    public final void parse(InputSource input) throws UncheckedIOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(this.isValidating);
            factory.setNamespaceAware(this.isNamespaceAware);
            if (this.isValidating) {
                factory.setFeature("http://apache.org/xml/features/validation/schema", true);
                SAXParser parser = factory.newSAXParser();
                XMLReader reader = parser.getXMLReader();
                reader.setContentHandler(this);
                reader.setErrorHandler(this);
                reader.setEntityResolver(this);
                reader.parse(input);
            } else {
                SAXParser parser = factory.newSAXParser();
                parser.parse(input, (DefaultHandler)this);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new UncheckedIOException(e);
        }
    }

    public final String getDoctype() {
        return this.doctype;
    }

    protected void setDoctype(String doctype) {
        this.doctype = doctype;
    }

    @Override
    public final InputSource resolveEntity(String publicId, String systemId) {
        InputSource source;
        int index = systemId.replace('\\', '/').lastIndexOf(47);
        String shortSystemId = systemId.substring(index + 1);
        if (this.doctype == null) {
            this.setDoctype(shortSystemId);
        }
        if (this.preferLocalDtds) {
            source = this.findDtdInLocalFilesystem(shortSystemId);
            if (source == null) {
                source = this.findDtdInClasspath(shortSystemId);
            }
            if (source == null) {
                source = MatsimXmlParser.findDtdInDefaultLocation(shortSystemId);
            }
            if (source == null) {
                source = MatsimXmlParser.findDtdInRemoteLocation(systemId);
            }
        } else {
            source = MatsimXmlParser.findDtdInRemoteLocation(systemId);
            if (source == null) {
                source = this.findDtdInLocalFilesystem(shortSystemId);
            }
            if (source == null) {
                source = this.findDtdInClasspath(shortSystemId);
            }
            if (source == null) {
                source = MatsimXmlParser.findDtdInDefaultLocation(shortSystemId);
            }
        }
        if (source == null) {
            log.warn("Could neither get the DTD from the web nor a local one. " + systemId);
        } else {
            source.setSystemId(systemId);
        }
        return source;
    }

    private static InputSource findDtdInRemoteLocation(String fullSystemId) {
        log.info("Trying to load " + fullSystemId + ". In some cases (e.g. network interface up but no connection), this may take a bit.");
        try {
            URL url = new URL(fullSystemId);
            URLConnection urlConn = url.openConnection();
            urlConn.setConnectTimeout(5000);
            urlConn.setReadTimeout(5000);
            urlConn.setAllowUserInteraction(false);
            InputStream is = urlConn.getInputStream();
            return new InputSource(is);
        }
        catch (IOException e) {
            log.info(e.toString() + ". May not be fatal, will try to load it locally.");
            return null;
        }
    }

    private InputSource findDtdInLocalFilesystem(String shortSystemId) {
        String localFileName;
        File dtdFile;
        if (this.localDtdBase != null && (dtdFile = new File(localFileName = this.localDtdBase + "/" + shortSystemId)).exists() && dtdFile.isFile() && dtdFile.canRead()) {
            log.info("Using the local DTD " + localFileName + " with absolute path " + dtdFile.getAbsolutePath());
            return new InputSource(dtdFile.getAbsolutePath());
        }
        return null;
    }

    private InputSource findDtdInClasspath(String shortSystemId) {
        InputStream stream = this.getClass().getResourceAsStream("/dtd/" + shortSystemId);
        if (stream != null) {
            log.info("Using local DTD from classpath:dtd/" + shortSystemId);
            return new InputSource(stream);
        }
        return null;
    }

    private static InputSource findDtdInDefaultLocation(String shortSystemId) {
        log.info("Trying to access local dtd folder at standard location ./dtd...");
        File dtdFile = new File("./dtd/" + shortSystemId);
        if (dtdFile.exists() && dtdFile.isFile() && dtdFile.canRead()) {
            log.info("Using the local DTD " + dtdFile.getAbsolutePath());
            return new InputSource(dtdFile.getAbsolutePath());
        }
        return null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        StringBuffer buffer = this.buffers.peek();
        if (buffer != null) {
            buffer.append(ch, start, length);
        }
    }

    @Override
    public final void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String tag = uri.length() == 0 ? qName : localName;
        this.buffers.push(new StringBuffer());
        this.startTag(tag, atts, this.theContext);
        this.theContext.push(tag);
    }

    @Override
    public final void endElement(String uri, String localName, String qName) throws SAXException {
        String tag = uri.length() == 0 ? qName : localName;
        this.theContext.pop();
        StringBuffer buffer = this.buffers.pop();
        this.endTag(tag, buffer.toString(), this.theContext);
    }

    @Override
    public final void error(SAXParseException ex) throws SAXException {
        if (this.theContext.isEmpty()) {
            System.err.println("Missing DOCTYPE.");
        }
        System.err.println("XML-ERROR: " + this.getInputSource(ex) + ", line " + ex.getLineNumber() + ", column " + ex.getColumnNumber() + ":");
        System.err.println(ex.toString());
        throw ex;
    }

    @Override
    public final void fatalError(SAXParseException ex) throws SAXException {
        System.err.println("XML-FATAL: " + this.getInputSource(ex) + ", line " + ex.getLineNumber() + ", column " + ex.getColumnNumber() + ":");
        System.err.println(ex.toString());
        throw ex;
    }

    @Override
    public final void warning(SAXParseException ex) throws SAXException {
        System.err.println("XML-WARNING: " + this.getInputSource(ex) + ", line " + ex.getLineNumber() + ", column " + ex.getColumnNumber() + ":");
        System.err.println(ex.getMessage());
    }

    private String getInputSource(SAXParseException ex) {
        System.out.println(ex.getPublicId());
        System.out.println(ex.getSystemId());
        System.out.println(ex.getCause());
        System.out.println(ex.getLocalizedMessage());
        System.out.println(ex.getMessage());
        if (ex.getSystemId() != null) {
            return ex.getSystemId();
        }
        if (ex.getPublicId() != null) {
            return ex.getPublicId();
        }
        return this.theSource;
    }
}

