/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.io;

import java.io.IOException;
import java.util.List;
import org.matsim.core.utils.collections.Tuple;
import org.matsim.core.utils.io.AbstractMatsimWriter;
import org.matsim.core.utils.io.UncheckedIOException;
import org.matsim.core.utils.io.XmlUtils;
import org.matsim.core.utils.misc.Time;

public abstract class MatsimXmlWriter
extends AbstractMatsimWriter {
    public static final String DEFAULT_DTD_LOCATION = "http://www.matsim.org/files/dtd/";
    public static final String MATSIM_NAMESPACE = "http://www.matsim.org/files/dtd";
    public static final String XMLNS = "xmlns";
    public static final String DEFAULTSCHEMANAMESPACELOCATION = "http://www.w3.org/2001/XMLSchema-instance";
    private int indentationLevel = 0;
    private String indentationString = "\t";
    private boolean doPrettyPrint = true;
    private boolean noWhitespaces = false;

    public final void setPrettyPrint(boolean doPrettyPrint) {
        this.doPrettyPrint = doPrettyPrint;
    }

    public final void setIndentationString(String indentationString) {
        this.indentationString = indentationString;
    }

    protected final void setIndentationLevel(int level) {
        this.indentationLevel = level;
    }

    protected final void writeXmlHead() throws UncheckedIOException {
        try {
            this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            if (this.doPrettyPrint) {
                this.writer.write("\n");
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected final void writeDoctype(String rootTag, String dtdUrl) throws UncheckedIOException {
        try {
            this.writer.write("<!DOCTYPE " + rootTag + " SYSTEM \"" + dtdUrl + "\">\n");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected static Tuple<String, String> createTuple(String one, String two) {
        return new Tuple<String, String>(one, two);
    }

    protected static Tuple<String, String> createTuple(String one, int two) {
        return MatsimXmlWriter.createTuple(one, Integer.toString(two));
    }

    protected static Tuple<String, String> createTuple(String one, double two) {
        return MatsimXmlWriter.createTuple(one, Double.toString(two));
    }

    protected static Tuple<String, String> createTuple(String one, boolean two) {
        return MatsimXmlWriter.createTuple(one, Boolean.toString(two));
    }

    protected static Tuple<String, String> createTimeTuple(String one, double sec) {
        return MatsimXmlWriter.createTuple(one, Time.writeTime(sec));
    }

    private void indent() throws IOException {
        for (int i = 0; i < this.indentationLevel; ++i) {
            this.writer.write(this.indentationString);
        }
    }

    protected final void writeStartTag(String tagname, List<Tuple<String, String>> attributes) throws UncheckedIOException {
        this.writeStartTag(tagname, attributes, false);
    }

    protected final void writeStartTag(String tagname, List<Tuple<String, String>> attributes, boolean closeElement) throws UncheckedIOException {
        try {
            if (this.doPrettyPrint) {
                this.writer.write("\n");
                this.indent();
                ++this.indentationLevel;
            }
            this.writer.write("<" + tagname);
            if (attributes != null) {
                for (Tuple<String, String> t : attributes) {
                    this.writer.write(" " + t.getFirst() + "=\"" + XmlUtils.encodeAttributeValue(t.getSecond()) + "\"");
                }
            }
            if (closeElement) {
                this.writer.write("/>");
                if (this.doPrettyPrint) {
                    --this.indentationLevel;
                }
            } else {
                this.writer.write(">");
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected final void writeContent(String content, boolean allowWhitespaces) throws UncheckedIOException {
        try {
            if (this.doPrettyPrint) {
                boolean bl = this.noWhitespaces = !allowWhitespaces;
                if (!this.noWhitespaces) {
                    this.writer.write("\n");
                    ++this.indentationLevel;
                    this.indent();
                }
            }
            this.writer.write(XmlUtils.encodeContent(content));
            if (!this.noWhitespaces) {
                --this.indentationLevel;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected final void writeEndTag(String tagname) throws UncheckedIOException {
        try {
            if (this.doPrettyPrint) {
                --this.indentationLevel;
                if (!this.noWhitespaces) {
                    this.writer.write("\n");
                    this.indent();
                } else {
                    this.noWhitespaces = false;
                }
            }
            this.writer.write("</" + tagname + ">");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected final void writeElement(String tagname, String content) throws UncheckedIOException {
        try {
            if (this.doPrettyPrint) {
                this.writer.write("\n");
                this.indent();
                ++this.indentationLevel;
            }
            this.writer.write("<" + tagname + ">");
            if (this.doPrettyPrint) {
                --this.indentationLevel;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        try {
            this.writer.write(XmlUtils.encodeContent(content));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        try {
            this.writer.write("</" + tagname + ">");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

