/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.api.internal.MatsimSomeReader;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.utils.geometry.CoordUtils;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.io.MatsimXmlParser;
import org.matsim.core.utils.io.UncheckedIOException;
import org.matsim.core.utils.misc.Counter;
import org.xml.sax.Attributes;

public class OsmNetworkReader
implements MatsimSomeReader {
    private static final Logger log = Logger.getLogger(OsmNetworkReader.class);
    private static final String TAG_LANES = "lanes";
    private static final String TAG_LANES_FORWARD = "lanes:forward";
    private static final String TAG_LANES_BACKWARD = "lanes:backward";
    private static final String TAG_HIGHWAY = "highway";
    private static final String TAG_MAXSPEED = "maxspeed";
    private static final String TAG_JUNCTION = "junction";
    private static final String TAG_ONEWAY = "oneway";
    private static final String TAG_ACCESS = "access";
    private static List<String> allTags = new LinkedList<String>(Arrays.asList("lanes", "lanes:forward", "lanes:backward", "highway", "maxspeed", "junction", "oneway", "access"));
    private final Map<Long, OsmNode> nodes = new HashMap<Long, OsmNode>();
    private final Map<Long, OsmWay> ways = new HashMap<Long, OsmWay>();
    private final Set<String> unknownHighways = new HashSet<String>();
    private final Set<String> unknownMaxspeedTags = new HashSet<String>();
    private final Set<String> unknownLanesTags = new HashSet<String>();
    private long id = 0L;
    protected final Map<String, OsmHighwayDefaults> highwayDefaults = new HashMap<String, OsmHighwayDefaults>();
    private final Network network;
    private final CoordinateTransformation transform;
    private boolean keepPaths = false;
    private boolean scaleMaxSpeed = false;
    private boolean slowButLowMemory = false;
    private boolean useVspAdjustments = false;
    final List<OsmFilter> hierarchyLayers = new ArrayList<OsmFilter>();
    private Set<Long> nodeIDsToKeep = null;

    public OsmNetworkReader(Network network, CoordinateTransformation transformation) {
        this(network, transformation, true);
    }

    public OsmNetworkReader(Network network, CoordinateTransformation transformation, boolean useHighwayDefaults) {
        this(network, transformation, useHighwayDefaults, false);
    }

    public OsmNetworkReader(Network network, CoordinateTransformation transformation, boolean useHighwayDefaults, boolean useVspAdjustments) {
        this.network = network;
        this.transform = transformation;
        this.useVspAdjustments = useVspAdjustments;
        if (useHighwayDefaults) {
            log.info("Falling back to default values.");
            this.setHighwayDefaults(1, "motorway", 2.0, 33.333333333333336, 1.0, 2000.0, true);
            this.setHighwayDefaults(1, "motorway_link", 1.0, 22.22222222222222, 1.0, 1500.0, true);
            this.setHighwayDefaults(2, "trunk", 1.0, 22.22222222222222, 1.0, 2000.0);
            this.setHighwayDefaults(2, "trunk_link", 1.0, 13.88888888888889, 1.0, 1500.0);
            if (useVspAdjustments) {
                this.setHighwayDefaults(3, "primary", 1.0, 22.22222222222222, 1.0, 1000.0);
                this.setHighwayDefaults(3, "primary_link", 1.0, 16.666666666666668, 1.0, 1000.0);
            } else {
                this.setHighwayDefaults(3, "primary", 1.0, 22.22222222222222, 1.0, 1500.0);
                this.setHighwayDefaults(3, "primary_link", 1.0, 16.666666666666668, 1.0, 1500.0);
            }
            if (useVspAdjustments) {
                this.setHighwayDefaults(4, "secondary", 1.0, 8.333333333333334, 1.0, 800.0);
                this.setHighwayDefaults(4, "secondary_link", 1.0, 8.333333333333334, 1.0, 800.0);
            } else {
                this.setHighwayDefaults(4, "secondary", 1.0, 8.333333333333334, 1.0, 1000.0);
                this.setHighwayDefaults(4, "secondary_link", 1.0, 8.333333333333334, 1.0, 1000.0);
            }
            this.setHighwayDefaults(5, "tertiary", 1.0, 6.944444444444445, 1.0, 600.0);
            this.setHighwayDefaults(5, "tertiary_link", 1.0, 6.944444444444445, 1.0, 600.0);
            this.setHighwayDefaults(6, "unclassified", 1.0, 4.166666666666667, 1.0, 600.0);
            this.setHighwayDefaults(7, "residential", 1.0, 4.166666666666667, 1.0, 600.0);
            this.setHighwayDefaults(8, "living_street", 1.0, 2.7777777777777777, 1.0, 300.0);
        }
    }

    public final void parse(String osmFilename) {
        this.parse(osmFilename, null);
    }

    public final void parse(Supplier<InputStream> streamSupplier) throws UncheckedIOException {
        this.parse(null, streamSupplier);
    }

    private void parse(String osmFilename, Supplier<InputStream> streamSupplier) throws UncheckedIOException {
        Throwable throwable;
        InputStream is;
        if (this.hierarchyLayers.isEmpty()) {
            log.warn("No hierarchy layer specified. Will convert every highway specified by setHighwayDefaults.");
        }
        OsmXmlParser parser = null;
        if (this.slowButLowMemory) {
            block51: {
                block50: {
                    log.info("parsing osm file first time: identifying nodes used by ways");
                    parser = new OsmXmlParser(this.nodes, this.ways, this.transform);
                    parser.enableOptimization(1);
                    if (streamSupplier != null) {
                        try {
                            is = streamSupplier.get();
                            throwable = null;
                            try {
                                parser.parse(is);
                                break block50;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (is != null) {
                                    if (throwable != null) {
                                        try {
                                            is.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                    } else {
                                        is.close();
                                    }
                                }
                            }
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                    parser.readFile(osmFilename);
                }
                log.info("parsing osm file second time: loading required nodes and ways");
                parser.enableOptimization(2);
                if (streamSupplier != null) {
                    try {
                        is = streamSupplier.get();
                        throwable = null;
                        try {
                            parser.parse(is);
                            break block51;
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (is != null) {
                                if (throwable != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    is.close();
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                parser.readFile(osmFilename);
            }
            log.info("done loading data");
        } else {
            block52: {
                parser = new OsmXmlParser(this.nodes, this.ways, this.transform);
                if (streamSupplier != null) {
                    try {
                        is = streamSupplier.get();
                        throwable = null;
                        try {
                            parser.parse(is);
                            break block52;
                        }
                        catch (Throwable throwable6) {
                            throwable = throwable6;
                            throw throwable6;
                        }
                        finally {
                            if (is != null) {
                                if (throwable != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable throwable7) {
                                        throwable.addSuppressed(throwable7);
                                    }
                                } else {
                                    is.close();
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                parser.readFile(osmFilename);
            }
            log.info("done loading data");
        }
        this.convert();
        log.info("= conversion statistics: ==========================");
        log.info("osm: # nodes read:       " + parser.nodeCounter.getCounter());
        log.info("osm: # ways read:        " + parser.wayCounter.getCounter());
        log.info("MATSim: # nodes created: " + this.network.getNodes().size());
        log.info("MATSim: # links created: " + this.network.getLinks().size());
        if (this.unknownHighways.size() > 0) {
            log.info("The following highway-types had no defaults set and were thus NOT converted:");
            for (String highwayType : this.unknownHighways) {
                log.info("- \"" + highwayType + "\"");
            }
        }
        log.info("= end of conversion statistics ====================");
    }

    public final void setHighwayDefaults(int hierarchy, String highwayType, double lanesPerDirection, double freespeed, double freespeedFactor, double laneCapacity_vehPerHour) {
        this.setHighwayDefaults(hierarchy, highwayType, lanesPerDirection, freespeed, freespeedFactor, laneCapacity_vehPerHour, false);
    }

    public final void setHighwayDefaults(int hierarchy, String highwayType, double lanesPerDirection, double freespeed, double freespeedFactor, double laneCapacity_vehPerHour, boolean oneway) {
        this.highwayDefaults.put(highwayType, new OsmHighwayDefaults(hierarchy, lanesPerDirection, freespeed, freespeedFactor, laneCapacity_vehPerHour, oneway));
    }

    public final void setKeepPaths(boolean keepPaths) {
        this.keepPaths = keepPaths;
    }

    public final void setScaleMaxSpeed(boolean scaleMaxSpeed) {
        this.scaleMaxSpeed = scaleMaxSpeed;
    }

    public final void setHierarchyLayer(double coordNWNorthing, double coordNWEasting, double coordSENorthing, double coordSEEasting, int hierarchy) {
        this.hierarchyLayers.add(new OsmFilterImpl(this.transform.transform(new Coord(coordNWEasting, coordNWNorthing)), this.transform.transform(new Coord(coordSEEasting, coordSENorthing)), hierarchy));
    }

    public final void setHierarchyLayer(int hierarchy) {
        this.hierarchyLayers.add(new GeographicallyNonrestrictingOsmFilterImpl(hierarchy));
    }

    public final void addOsmFilter(OsmFilter osmFilter) {
        this.hierarchyLayers.add(osmFilter);
    }

    public final void setMemoryOptimization(boolean memoryEnabled) {
        this.slowButLowMemory = memoryEnabled;
    }

    public final void setNodeIDsToKeep(Set<Long> nodeIDsToKeep) {
        if (nodeIDsToKeep != null && !nodeIDsToKeep.isEmpty()) {
            this.nodeIDsToKeep = nodeIDsToKeep;
        }
    }

    protected void addWayTags(List<String> wayTagsToAdd) {
        allTags.addAll(wayTagsToAdd);
    }

    private void convert() {
        String highway;
        this.network.setCapacityPeriod(3600.0);
        log.info("Remove ways that have at least one node that was not read previously ...");
        Iterator<Map.Entry<Long, OsmWay>> it = this.ways.entrySet().iterator();
        int counter = 0;
        block0: while (it.hasNext()) {
            Iterator<Object> entry = it.next();
            for (Long nodeId : entry.getValue().nodes) {
                if (this.nodes.get(nodeId) != null) continue;
                it.remove();
                continue block0;
            }
        }
        log.info("... done removing " + counter + "ways that have at least one node that was not read previously.");
        log.info("Mark OSM nodes that shoud be kept ...");
        for (OsmWay osmWay : this.ways.values()) {
            highway = osmWay.tags.get(TAG_HIGHWAY);
            if (highway == null || !this.highwayDefaults.containsKey(highway)) continue;
            osmWay.hierarchy = this.highwayDefaults.get((Object)highway).hierarchy;
            ++this.nodes.get((Object)osmWay.nodes.get((int)0)).ways;
            ++this.nodes.get((Object)osmWay.nodes.get((int)(osmWay.nodes.size() - 1))).ways;
            block3: for (Long nodeId : osmWay.nodes) {
                OsmNode node = this.nodes.get(nodeId);
                if (this.hierarchyLayers.isEmpty()) {
                    node.used = true;
                    ++node.ways;
                    continue;
                }
                for (OsmFilter osmFilter : this.hierarchyLayers) {
                    if (!osmFilter.coordInFilter(node.coord, osmWay.hierarchy)) continue;
                    node.used = true;
                    ++node.ways;
                    continue block3;
                }
            }
        }
        log.info("... done marking OSM nodes that shoud be kept.");
        if (!this.keepPaths) {
            log.info("Mark nodes as unused where only one way leads through ...");
            for (OsmNode osmNode : this.nodes.values()) {
                if (osmNode.ways != 1) continue;
                osmNode.used = false;
            }
            log.info("... done marking nodes as unused where only one way leads through.");
            log.info("Verify we did not mark nodes as unused that build a loop ...");
            for (OsmWay osmWay : this.ways.values()) {
                highway = osmWay.tags.get(TAG_HIGHWAY);
                if (highway == null || !this.highwayDefaults.containsKey(highway)) continue;
                int prevRealNodeIndex = 0;
                OsmNode prevRealNode = this.nodes.get(osmWay.nodes.get(prevRealNodeIndex));
                for (int i = 1; i < osmWay.nodes.size(); ++i) {
                    OsmNode node = this.nodes.get(osmWay.nodes.get(i));
                    if (!node.used) continue;
                    if (prevRealNode == node) {
                        double nextNodeToKeep;
                        double increment = Math.sqrt(i - prevRealNodeIndex);
                        for (double j = nextNodeToKeep = (double)prevRealNodeIndex + increment; j < (double)i; j += increment) {
                            int index = (int)Math.floor(j);
                            OsmNode intermediaryNode = this.nodes.get(osmWay.nodes.get(index));
                            intermediaryNode.used = true;
                        }
                    }
                    prevRealNodeIndex = i;
                    prevRealNode = node;
                }
            }
            log.info("... done verifying that we did not mark nodes as unused that build a loop.");
        }
        if (this.nodeIDsToKeep != null) {
            int cnt = 0;
            log.info("...assure that all nodes that are definitely to be kept are marked as used");
            for (Long nodeToBeKept : this.nodeIDsToKeep) {
                OsmNode node = this.nodes.get(nodeToBeKept);
                if (node == null) {
                    log.warn("cannot find node " + nodeToBeKept + ". maybe it was not read in or got deleted..");
                    continue;
                }
                node.used = true;
                ++cnt;
            }
            log.info("..found " + cnt + " out of " + this.nodeIDsToKeep.size() + " nodes to keep and marked them as used..");
        }
        log.info("Create the required nodes ...");
        for (OsmNode osmNode : this.nodes.values()) {
            if (!osmNode.used) continue;
            Node nn = this.network.getFactory().createNode(Id.create(osmNode.id, Node.class), osmNode.coord);
            this.setOrModifyNodeAttributes(nn, osmNode);
            this.network.addNode(nn);
        }
        log.info("... done creating the required nodes.");
        log.info("Create the links ...");
        this.id = 1L;
        for (OsmWay osmWay : this.ways.values()) {
            highway = osmWay.tags.get(TAG_HIGHWAY);
            if (highway == null) continue;
            OsmNode fromNode = this.nodes.get(osmWay.nodes.get(0));
            double length = 0.0;
            OsmNode lastToNode = fromNode;
            if (!fromNode.used) continue;
            int n = osmWay.nodes.size();
            for (int i = 1; i < n; ++i) {
                OsmNode toNode = this.nodes.get(osmWay.nodes.get(i));
                if (toNode == lastToNode) continue;
                length += CoordUtils.calcEuclideanDistance(lastToNode.coord, toNode.coord);
                if (toNode.used) {
                    if (this.hierarchyLayers.isEmpty()) {
                        this.createLink(this.network, osmWay, fromNode, toNode, length);
                    } else {
                        for (OsmFilter osmFilter : this.hierarchyLayers) {
                            if (osmFilter.coordInFilter(fromNode.coord, osmWay.hierarchy)) {
                                this.createLink(this.network, osmWay, fromNode, toNode, length);
                                break;
                            }
                            if (!osmFilter.coordInFilter(toNode.coord, osmWay.hierarchy)) continue;
                            this.createLink(this.network, osmWay, fromNode, toNode, length);
                            break;
                        }
                    }
                    fromNode = toNode;
                    length = 0.0;
                }
                lastToNode = toNode;
            }
        }
        log.info("... done creating the links.");
        this.nodes.clear();
        this.ways.clear();
    }

    private void createLink(Network network, OsmWay way, OsmNode fromNode, OsmNode toNode, double length) {
        double freespeedFactor;
        double freespeed;
        double laneCapacity;
        double nofLanesBackward;
        double nofLanesForward;
        String highway;
        block29: {
            String lanesTag;
            boolean onewayReverse;
            boolean oneway;
            block28: {
                String maxspeedTag;
                highway = way.tags.get(TAG_HIGHWAY);
                if ("no".equals(way.tags.get(TAG_ACCESS))) {
                    return;
                }
                OsmHighwayDefaults defaults = this.highwayDefaults.get(highway);
                if (defaults == null) {
                    this.unknownHighways.add(highway);
                    return;
                }
                nofLanesForward = defaults.lanesPerDirection;
                nofLanesBackward = defaults.lanesPerDirection;
                laneCapacity = defaults.laneCapacity;
                freespeed = defaults.freespeed;
                freespeedFactor = defaults.freespeedFactor;
                oneway = this.isOneway(way);
                onewayReverse = this.isOnewayReverse(way);
                if (highway.equalsIgnoreCase("trunk") || highway.equalsIgnoreCase("primary") || highway.equalsIgnoreCase("secondary")) {
                    if (oneway && nofLanesForward == 1.0) {
                        nofLanesForward = 2.0;
                    } else if (onewayReverse && nofLanesBackward == 1.0) {
                        nofLanesBackward = 2.0;
                    }
                }
                if ((maxspeedTag = way.tags.get(TAG_MAXSPEED)) != null) {
                    try {
                        freespeed = maxspeedTag.endsWith("mph") ? Double.parseDouble(maxspeedTag.replace("mph", "").trim()) * 1.609344 / 3.6 : Double.parseDouble(maxspeedTag) / 3.6;
                        if (this.useVspAdjustments && freespeed <= 14.166666666666666) {
                            freespeed /= 2.0;
                        }
                        break block28;
                    }
                    catch (NumberFormatException e) {
                        if (!this.unknownMaxspeedTags.contains(maxspeedTag)) {
                            this.unknownMaxspeedTags.add(maxspeedTag);
                            log.warn("Could not parse maxspeed tag:" + e.getMessage() + ". Ignoring it.");
                        }
                        break block28;
                    }
                }
                if (this.useVspAdjustments && (highway.equalsIgnoreCase("primary") || highway.equalsIgnoreCase("secondary") || highway.equalsIgnoreCase("tertiary") || highway.equalsIgnoreCase("primary_link") || highway.equalsIgnoreCase("secondary_link") || highway.equalsIgnoreCase("tertiary_link"))) {
                    freespeed = length > 300.0 ? 22.22222222222222 : (10.0 + 0.23333333333333334 * length) / 3.6;
                }
            }
            if (this.useVspAdjustments && length < 100.0) {
                laneCapacity = 2.0 * laneCapacity;
            }
            if ((lanesTag = way.tags.get(TAG_LANES)) != null) {
                try {
                    double totalNofLanes = Double.parseDouble(lanesTag);
                    if (totalNofLanes > 0.0) {
                        String lanesForwardTag = way.tags.get(TAG_LANES_FORWARD);
                        if (lanesForwardTag != null) {
                            double parsedForwardLanes = Double.parseDouble(lanesForwardTag);
                            if (parsedForwardLanes > 0.0) {
                                nofLanesForward = parsedForwardLanes;
                            }
                        } else {
                            nofLanesForward = oneway ? totalNofLanes : totalNofLanes / 2.0;
                        }
                        String lanesBackwardTag = way.tags.get(TAG_LANES_BACKWARD);
                        if (lanesBackwardTag != null) {
                            double parsedBackwardLanes = Double.parseDouble(lanesBackwardTag);
                            if (parsedBackwardLanes > 0.0) {
                                nofLanesBackward = parsedBackwardLanes;
                            }
                        } else {
                            nofLanesBackward = onewayReverse ? totalNofLanes : totalNofLanes / 2.0;
                        }
                    }
                }
                catch (Exception e) {
                    if (this.unknownLanesTags.contains(lanesTag)) break block29;
                    this.unknownLanesTags.add(lanesTag);
                    log.warn("Could not parse lanes tag:" + e.getMessage() + ". Ignoring it.");
                }
            }
        }
        double capacityForward = nofLanesForward * laneCapacity;
        double capacityBackward = nofLanesBackward * laneCapacity;
        if (this.scaleMaxSpeed) {
            freespeed *= freespeedFactor;
            if (this.useVspAdjustments) {
                throw new RuntimeException("Max speed scaling and VSP adjustments used at the same time. Both reduce speeds. It is most likely unintended to use them both at the same time. ik,dz, spr'18");
            }
        }
        Id<Node> fromId = Id.create(fromNode.id, Node.class);
        Id<Node> toId = Id.create(toNode.id, Node.class);
        if (network.getNodes().get(fromId) != null && network.getNodes().get(toId) != null) {
            Link l;
            String origId = Long.toString(way.id);
            if (this.forwardDirectionExists(way)) {
                l = network.getFactory().createLink(Id.create(this.id, Link.class), network.getNodes().get(fromId), network.getNodes().get(toId));
                l.setLength(length);
                l.setFreespeed(freespeed);
                l.setCapacity(capacityForward);
                l.setNumberOfLanes(nofLanesForward);
                NetworkUtils.setOrigId(l, origId);
                NetworkUtils.setType(l, highway);
                this.setOrModifyLinkAttributes(l, way, true);
                network.addLink(l);
                ++this.id;
            }
            if (this.reverseDirectionExists(way)) {
                l = network.getFactory().createLink(Id.create(this.id, Link.class), network.getNodes().get(toId), network.getNodes().get(fromId));
                l.setLength(length);
                l.setFreespeed(freespeed);
                l.setCapacity(capacityBackward);
                l.setNumberOfLanes(nofLanesBackward);
                NetworkUtils.setOrigId(l, origId);
                NetworkUtils.setType(l, highway);
                this.setOrModifyLinkAttributes(l, way, false);
                network.addLink(l);
                ++this.id;
            }
        }
    }

    protected boolean isOneway(OsmWay way) {
        String onewayTag = way.tags.get(TAG_ONEWAY);
        if (onewayTag != null) {
            if ("yes".equals(onewayTag) || "true".equals(onewayTag) || "1".equals(onewayTag)) {
                return true;
            }
            if ("-1".equals(onewayTag) || "reverse".equals(onewayTag)) {
                return false;
            }
            if ("no".equals(onewayTag) || "false".equals(onewayTag) || "0".equals(onewayTag)) {
                return false;
            }
            log.warn("Could not interpret oneway tag:" + onewayTag + ". Ignoring it.");
        }
        if ("roundabout".equals(way.tags.get(TAG_JUNCTION))) {
            return true;
        }
        OsmHighwayDefaults defaults = this.highwayDefaults.get(way.tags.get(TAG_HIGHWAY));
        return defaults.oneway;
    }

    protected boolean isOnewayReverse(OsmWay way) {
        String onewayTag = way.tags.get(TAG_ONEWAY);
        if (onewayTag != null) {
            if ("yes".equals(onewayTag) || "true".equals(onewayTag) || "1".equals(onewayTag)) {
                return false;
            }
            if ("-1".equals(onewayTag) || "reverse".equals(onewayTag)) {
                return true;
            }
            if ("no".equals(onewayTag) || "false".equals(onewayTag) || "0".equals(onewayTag)) {
                return false;
            }
            log.warn("Could not interpret oneway tag:" + onewayTag + ". Ignoring it.");
        }
        return false;
    }

    protected void setOrModifyNodeAttributes(Node n, OsmNode node) {
    }

    protected void setOrModifyLinkAttributes(Link l, OsmWay way, boolean forwardDirection) {
    }

    protected boolean reverseDirectionExists(OsmWay way) {
        return !this.isOneway(way);
    }

    protected boolean forwardDirectionExists(OsmWay way) {
        return !this.isOnewayReverse(way);
    }

    private static class StringCache {
        private static ConcurrentHashMap<String, String> cache = new ConcurrentHashMap(10000);

        private StringCache() {
        }

        public static String get(String string) {
            String s2 = cache.putIfAbsent(string, string);
            if (s2 == null) {
                return string;
            }
            return s2;
        }
    }

    private class OsmXmlParser
    extends MatsimXmlParser {
        private OsmWay currentWay = null;
        private final Map<Long, OsmNode> nodes;
        private final Map<Long, OsmWay> ways;
        final Counter nodeCounter = new Counter("node ");
        final Counter wayCounter = new Counter("way ");
        private final CoordinateTransformation transform;
        private boolean loadNodes = true;
        private boolean loadWays = true;
        private boolean mergeNodes = false;
        private boolean collectNodes = false;

        public OsmXmlParser(Map<Long, OsmNode> nodes, Map<Long, OsmWay> ways, CoordinateTransformation transform) {
            this.nodes = nodes;
            this.ways = ways;
            this.transform = transform;
            this.setValidating(false);
        }

        public void enableOptimization(int step) {
            this.loadNodes = false;
            this.loadWays = false;
            this.collectNodes = false;
            this.mergeNodes = false;
            if (step == 1) {
                this.collectNodes = true;
            } else if (step == 2) {
                this.mergeNodes = true;
                this.loadWays = true;
            }
        }

        @Override
        public void startTag(String name, Attributes atts, Stack<String> context) {
            block4: {
                block6: {
                    block5: {
                        block2: {
                            Coord c;
                            OsmNode node;
                            block3: {
                                if (!"node".equals(name)) break block2;
                                if (!this.loadNodes) break block3;
                                Long id = Long.valueOf(atts.getValue("id"));
                                double lat = Double.parseDouble(atts.getValue("lat"));
                                double lon = Double.parseDouble(atts.getValue("lon"));
                                this.nodes.put(id, new OsmNode(id, this.transform.transform(new Coord(lon, lat))));
                                this.nodeCounter.incCounter();
                                break block4;
                            }
                            if (!this.mergeNodes || (node = this.nodes.get(Long.valueOf(atts.getValue("id")))) == null) break block4;
                            double lat = Double.parseDouble(atts.getValue("lat"));
                            double lon = Double.parseDouble(atts.getValue("lon"));
                            node.coord = c = this.transform.transform(new Coord(lon, lat));
                            this.nodeCounter.incCounter();
                            break block4;
                        }
                        if (!"way".equals(name)) break block5;
                        this.currentWay = new OsmWay(Long.parseLong(atts.getValue("id")));
                        break block4;
                    }
                    if (!"nd".equals(name)) break block6;
                    if (this.currentWay == null) break block4;
                    this.currentWay.nodes.add(Long.parseLong(atts.getValue("ref")));
                    break block4;
                }
                if ("tag".equals(name) && this.currentWay != null) {
                    String key = StringCache.get(atts.getValue("k"));
                    for (String tag : allTags) {
                        if (!tag.equals(key)) continue;
                        this.currentWay.tags.put(key, StringCache.get(atts.getValue("v")));
                        break;
                    }
                }
            }
        }

        @Override
        public void endTag(String name, String content, Stack<String> context) {
            if ("way".equals(name)) {
                if (!this.currentWay.nodes.isEmpty()) {
                    boolean used = false;
                    OsmHighwayDefaults osmHighwayDefaults = OsmNetworkReader.this.highwayDefaults.get(this.currentWay.tags.get(OsmNetworkReader.TAG_HIGHWAY));
                    if (osmHighwayDefaults != null) {
                        int hierarchy;
                        this.currentWay.hierarchy = hierarchy = osmHighwayDefaults.hierarchy;
                        if (OsmNetworkReader.this.hierarchyLayers.isEmpty()) {
                            used = true;
                        }
                        if (this.collectNodes) {
                            used = true;
                        } else {
                            for (OsmFilter osmFilter : OsmNetworkReader.this.hierarchyLayers) {
                                for (Long nodeId : this.currentWay.nodes) {
                                    OsmNode node = this.nodes.get(nodeId);
                                    if (node == null || !osmFilter.coordInFilter(node.coord, this.currentWay.hierarchy)) continue;
                                    used = true;
                                    break;
                                }
                                if (!used) continue;
                                break;
                            }
                        }
                    }
                    if (used) {
                        if (this.collectNodes) {
                            for (long id : this.currentWay.nodes) {
                                this.nodes.put(id, new OsmNode(id, new Coord(0.0, 0.0)));
                            }
                        } else if (this.loadWays) {
                            this.ways.put(this.currentWay.id, this.currentWay);
                            this.wayCounter.incCounter();
                        }
                    }
                }
                this.currentWay = null;
            }
        }
    }

    protected static class OsmHighwayDefaults {
        public final int hierarchy;
        public final double lanesPerDirection;
        public final double freespeed;
        public final double freespeedFactor;
        public final double laneCapacity;
        public final boolean oneway;

        public OsmHighwayDefaults(int hierarchy, double lanesPerDirection, double freespeed, double freespeedFactor, double laneCapacity, boolean oneway) {
            this.hierarchy = hierarchy;
            this.lanesPerDirection = lanesPerDirection;
            this.freespeed = freespeed;
            this.freespeedFactor = freespeedFactor;
            this.laneCapacity = laneCapacity;
            this.oneway = oneway;
        }
    }

    protected static class OsmWay {
        public final long id;
        public final List<Long> nodes = new ArrayList<Long>(4);
        public final Map<String, String> tags = new HashMap<String, String>(4);
        public int hierarchy = -1;

        public OsmWay(long id) {
            this.id = id;
        }
    }

    protected static class OsmNode {
        public final long id;
        public boolean used = false;
        public int ways = 0;
        public Coord coord;

        public OsmNode(long id, Coord coord) {
            this.id = id;
            this.coord = coord;
        }
    }

    private static class GeographicallyNonrestrictingOsmFilterImpl
    implements OsmFilter {
        private final int hierarchy;

        GeographicallyNonrestrictingOsmFilterImpl(int hierarchy) {
            this.hierarchy = hierarchy;
        }

        @Override
        public boolean coordInFilter(Coord coord, int hierarchyLevel) {
            return this.hierarchy >= hierarchyLevel;
        }
    }

    private static class OsmFilterImpl
    implements OsmFilter {
        private final Coord coordNW;
        private final Coord coordSE;
        private final int hierarchy;

        OsmFilterImpl(Coord coordNW, Coord coordSE, int hierarchy) {
            this.coordNW = coordNW;
            this.coordSE = coordSE;
            this.hierarchy = hierarchy;
        }

        @Override
        public boolean coordInFilter(Coord coord, int hierarchyLevel) {
            if (this.hierarchy < hierarchyLevel) {
                return false;
            }
            return this.coordNW.getX() < coord.getX() && coord.getX() < this.coordSE.getX() && this.coordNW.getY() > coord.getY() && coord.getY() > this.coordSE.getY();
        }
    }

    public static interface OsmFilter {
        public boolean coordInFilter(Coord var1, int var2);
    }
}

