/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class UnicodeInputStream
extends InputStream {
    private final PushbackInputStream in;
    private final BOM bom;

    public UnicodeInputStream(InputStream inputStream) throws NullPointerException, IOException {
        this(inputStream, true);
    }

    public UnicodeInputStream(InputStream inputStream, boolean skipBom) throws NullPointerException, IOException {
        if (inputStream == null) {
            throw new NullPointerException("invalid input stream: null is not allowed");
        }
        this.in = new PushbackInputStream(inputStream, 4);
        byte[] bytes = new byte[4];
        int read = this.in.read(bytes);
        switch (read) {
            case 4: {
                if (bytes[0] == -1 && bytes[1] == -2 && bytes[2] == 0 && bytes[3] == 0) {
                    this.bom = BOM.UTF_32_LE;
                    break;
                }
                if (bytes[0] == 0 && bytes[1] == 0 && bytes[2] == -2 && bytes[3] == -1) {
                    this.bom = BOM.UTF_32_BE;
                    break;
                }
            }
            case 3: {
                if (bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65) {
                    this.bom = BOM.UTF_8;
                    break;
                }
            }
            case 2: {
                if (bytes[0] == -1 && bytes[1] == -2) {
                    this.bom = BOM.UTF_16_LE;
                    break;
                }
                if (bytes[0] == -2 && bytes[1] == -1) {
                    this.bom = BOM.UTF_16_BE;
                    break;
                }
            }
            default: {
                this.bom = BOM.NONE;
            }
        }
        if (read > 0) {
            this.in.unread(bytes, 0, read);
        }
        if (skipBom) {
            this.in.skip(this.bom.bytes.length);
        }
    }

    public final BOM getBOM() {
        return this.bom;
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b) throws IOException, NullPointerException {
        return this.in.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException, NullPointerException {
        return this.in.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    public static final class BOM {
        public static final BOM NONE = new BOM(new byte[0], "NONE");
        public static final BOM UTF_8 = new BOM(new byte[]{-17, -69, -65}, "UTF-8");
        public static final BOM UTF_16_LE = new BOM(new byte[]{-1, -2}, "UTF-16 little-endian");
        public static final BOM UTF_16_BE = new BOM(new byte[]{-2, -1}, "UTF-16 big-endian");
        public static final BOM UTF_32_LE = new BOM(new byte[]{-1, -2, 0, 0}, "UTF-32 little-endian");
        public static final BOM UTF_32_BE = new BOM(new byte[]{0, 0, -2, -1}, "UTF-32 big-endian");
        final byte[] bytes;
        private final String description;

        public final String toString() {
            return this.description;
        }

        public final byte[] getBytes() {
            int length = this.bytes.length;
            byte[] result = new byte[length];
            System.arraycopy(this.bytes, 0, result, 0, length);
            return result;
        }

        private BOM(byte[] bom, String description) {
            this.bytes = bom;
            this.description = description;
        }
    }
}

