/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.io.tabularFileParser;

import java.io.BufferedReader;
import java.io.IOException;
import org.matsim.core.api.internal.MatsimSomeReader;
import org.matsim.core.utils.io.IOUtils;
import org.matsim.core.utils.io.tabularFileParser.TabularFileHandler;
import org.matsim.core.utils.io.tabularFileParser.TabularFileParserConfig;

public class TabularFileParser
implements MatsimSomeReader {
    private TabularFileParserConfig config = null;

    private boolean isStart(String line) {
        String regex = this.config.getStartRegex();
        if (regex == null) {
            return true;
        }
        return line.matches(regex);
    }

    private boolean isEnd(String line) {
        String regex = this.config.getEndRegex();
        if (regex == null) {
            return false;
        }
        return line.matches(regex);
    }

    private boolean isComment(String line) {
        String regex = this.config.getCommentRegex();
        if (regex == null) {
            return false;
        }
        return line.matches(regex);
    }

    private String[] split(String line) {
        String regex = this.config.getDelimiterRegex();
        if (regex == null) {
            return new String[]{line};
        }
        return line.split(regex);
    }

    public void parse(TabularFileParserConfig config, TabularFileHandler handler) {
        if (config == null) {
            throw new NullPointerException("TabularFileParser requires a non-null configuration.");
        }
        if (handler == null) {
            throw new NullPointerException("TabularFileParser requires a non-null handler.");
        }
        this.config = config;
        boolean started = config.getStartRegex() == null;
        boolean ended = false;
        try (BufferedReader reader = config.getUrl() == null ? IOUtils.getBufferedReader(config.getFile(), config.getCharset()) : IOUtils.getBufferedReader(config.getUrl(), config.getCharset());){
            String line;
            while ((line = reader.readLine()) != null && !ended) {
                if (started) {
                    ended = this.isEnd(line);
                    if (ended || this.isComment(line)) continue;
                    handler.startRow(this.split(line));
                    continue;
                }
                started = this.isStart(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

