/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.io.tabularFileParser;

import java.net.URL;
import java.nio.charset.Charset;

public class TabularFileParserConfig {
    private static final String ANYTHING = ".*";
    private static final String ANY_SPACE = "\\s*";
    private String file = null;
    private URL url = null;
    private String startRegex = null;
    private String endRegex = null;
    private String commentRegex = null;
    private String delimiterRegex = null;
    private Charset charset = Charset.forName("UTF8");

    public void setFileName(String file) {
        this.file = file;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void setStartRegex(String regex) {
        this.startRegex = regex;
    }

    public void setEndRegex(String regex) {
        this.endRegex = regex;
    }

    public void setCommentRegex(String regex) {
        this.commentRegex = regex;
    }

    public void setDelimiterRegex(String regex) {
        this.delimiterRegex = regex;
    }

    public void setStartTag(String tag) {
        if (tag != null) {
            this.startRegex = this.quote(tag) + ANYTHING;
        }
    }

    public void setEndTag(String tag) {
        if (tag != null) {
            this.endRegex = this.quote(tag) + ANYTHING;
        }
    }

    public void setCommentTags(String[] tags) {
        this.commentRegex = this.alternativeExpr(tags) + ANYTHING;
    }

    public void setDelimiterTags(String[] tags) {
        this.delimiterRegex = tags == null || tags.length == 0 ? null : ANY_SPACE + this.alternativeExpr(tags) + ANY_SPACE;
    }

    private String alternativeExpr(String[] alternatives) {
        StringBuilder result = new StringBuilder();
        if (alternatives != null) {
            for (int i = 0; i < alternatives.length; ++i) {
                result.append(this.quote(alternatives[i]));
                if (i >= alternatives.length - 1) continue;
                result.append('|');
            }
        }
        return result.toString();
    }

    private String quote(String expr) {
        return "\\Q" + expr + "\\E";
    }

    public String getFile() {
        return this.file;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getStartRegex() {
        return this.startRegex;
    }

    public String getEndRegex() {
        return this.endRegex;
    }

    public String getCommentRegex() {
        return this.commentRegex;
    }

    public String getDelimiterRegex() {
        return this.delimiterRegex;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(100);
        result.append("TabularFileParserConfig:\n\tfile=");
        result.append(this.file);
        result.append("\n\tstartRegex=");
        result.append(this.startRegex);
        result.append("\n\tendRegex=");
        result.append(this.endRegex);
        result.append("\n\tcommentRegex=");
        result.append(this.commentRegex);
        result.append("\n\tdelimiterRegex=");
        result.append(this.delimiterRegex);
        return result.toString();
    }
}

