/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.misc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ArgumentParser
implements Iterable<String> {
    private List<String> args = new ArrayList<String>();
    private boolean enableShortOptions = true;

    public ArgumentParser(String[] args) {
        this(args, false);
    }

    public ArgumentParser(String[] args, boolean enableShortOptions) {
        this.enableShortOptions = enableShortOptions;
        this.parse(args);
    }

    @Override
    public Iterator<String> iterator() {
        return this.args.iterator();
    }

    private void parse(String[] args) {
        if (this.enableShortOptions) {
            for (String arg : args) {
                if (arg.startsWith("--")) {
                    this.parseLongOption(arg.substring(2));
                    continue;
                }
                if (arg.startsWith("-")) {
                    this.parseShortOption(arg.substring(1));
                    continue;
                }
                this.args.add(arg);
            }
        } else {
            for (String arg : args) {
                if (arg.startsWith("-")) {
                    this.parseOption(arg);
                    continue;
                }
                this.args.add(arg);
            }
        }
    }

    private void parseShortOption(String arg) {
        if (arg.length() == 0) {
            this.args.add("-");
            return;
        }
        for (int i = 0; i < arg.length(); ++i) {
            char ch = arg.charAt(i);
            if (ch == '=') {
                if (i == 0 && arg.length() == 1) {
                    this.args.add("-=");
                    return;
                }
                if (i == 0) {
                    this.args.add('-' + arg);
                    return;
                }
                this.args.add(arg.substring(i + 1));
                return;
            }
            this.args.add("-" + ch);
        }
    }

    private void parseLongOption(String arg) {
        StringBuilder argname = new StringBuilder("--");
        for (int i = 0; i < arg.length(); ++i) {
            char ch = arg.charAt(i);
            if (ch == '=') {
                if (i == 0 && arg.length() == 1) {
                    this.args.add("--=");
                    return;
                }
                if (i == 0) {
                    this.args.add("--" + arg);
                    return;
                }
                this.args.add(argname.toString());
                this.args.add(arg.substring(i + 1));
                return;
            }
            argname.append(ch);
        }
        this.args.add(argname.toString());
    }

    private void parseOption(String arg) {
        StringBuilder argname = new StringBuilder();
        argname.append('-');
        for (int i = 1; i < arg.length(); ++i) {
            char ch = arg.charAt(i);
            if (ch == '=') {
                if (argname.toString().equals("-")) {
                    this.args.add(arg);
                    return;
                }
                if (argname.toString().equals("--")) {
                    this.args.add(arg);
                    return;
                }
                this.args.add(argname.toString());
                this.args.add(arg.substring(i + 1));
                return;
            }
            argname.append(ch);
        }
        this.args.add(argname.toString());
    }
}

