/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.misc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class ByteBufferUtils {
    public static void putString(ByteBuffer buffer, String string) {
        buffer.putInt(string.length());
        for (int i = 0; i < string.length(); ++i) {
            buffer.putChar(string.charAt(i));
        }
    }

    public static String getString(ByteBuffer buffer) {
        int length = buffer.getInt();
        char[] chBuffer = new char[length];
        for (int i = 0; i < length; ++i) {
            chBuffer[i] = buffer.getChar();
        }
        return new String(chBuffer);
    }

    public static void putObject(ByteBuffer buffer, Serializable o) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             ObjectOutputStream oout = new ObjectOutputStream(bos);){
            oout.writeObject(o);
            byte[] laneBytes = bos.toByteArray();
            buffer.putInt(laneBytes.length);
            for (int i = 0; i < laneBytes.length; ++i) {
                buffer.put(laneBytes[i]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Object getObject(ByteBuffer buffer) {
        int length = buffer.getInt();
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = buffer.get();
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        Object o = null;
        try (ObjectInputStream oin = new ObjectInputStream(bis);){
            o = oin.readObject();
            bis.close();
            oin.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return o;
    }
}

