/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.misc;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

public final class Counter {
    private final String prefix;
    private final String suffix;
    private final int multiplier;
    private final AtomicLong counter = new AtomicLong(0L);
    private final AtomicLong nextCounter = new AtomicLong(1L);
    private static final Logger log = Logger.getLogger(Counter.class);

    public Counter(String prefix) {
        this(prefix, "");
    }

    public Counter(String prefix, String suffix) {
        this(prefix, suffix, 2);
    }

    public Counter(String prefix, String suffix, int multiplier) {
        this.prefix = prefix;
        this.suffix = suffix;
        this.multiplier = multiplier;
    }

    public void incCounter() {
        long n;
        long i = this.counter.incrementAndGet();
        if (i >= (n = this.nextCounter.get()) && this.nextCounter.compareAndSet(n, n * (long)this.multiplier)) {
            log.info(this.prefix + n + this.suffix);
        }
    }

    public void printCounter() {
        log.info(this.prefix + this.counter.get() + this.suffix);
    }

    public long getCounter() {
        return this.counter.get();
    }

    public void reset() {
        this.counter.set(0L);
        this.nextCounter.set(1L);
    }
}

