/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.misc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.Arrays;
import org.apache.log4j.Logger;

public abstract class ExeRunner {
    static final Logger log = Logger.getLogger(ExeRunner.class);

    public static int run(String cmd, String stdoutFileName, int timeout) {
        return ExeRunner.run(cmd, stdoutFileName, timeout, null);
    }

    public static int run(String[] cmdArgs, String stdoutFileName, int timeout) {
        return ExeRunner.run(cmdArgs, stdoutFileName, timeout, null);
    }

    public static int run(String cmd, String stdoutFileName, int timeout, String workingDirectory) {
        ExternalExecutor myExecutor = new ExternalExecutor(cmd, stdoutFileName, workingDirectory);
        return ExeRunner.waitForFinish(myExecutor, timeout);
    }

    public static int run(String[] cmdArgs, String stdoutFileName, int timeout, String workingDirectory) {
        ExternalExecutor myExecutor = new ExternalExecutor(cmdArgs, stdoutFileName, workingDirectory);
        return ExeRunner.waitForFinish(myExecutor, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int waitForFinish(ExternalExecutor myExecutor, int timeout) {
        ExternalExecutor externalExecutor = myExecutor;
        synchronized (externalExecutor) {
            try {
                long timeoutMillis = 1000L * (long)timeout;
                long startTime = System.currentTimeMillis();
                myExecutor.start();
                while (System.currentTimeMillis() - startTime < timeoutMillis) {
                    myExecutor.wait(timeoutMillis -= System.currentTimeMillis() - startTime);
                    if (!myExecutor.getState().equals((Object)Thread.State.TERMINATED)) continue;
                }
                if (!myExecutor.getState().equals((Object)Thread.State.TERMINATED)) {
                    myExecutor.timeout = true;
                    myExecutor.interrupt();
                    myExecutor.join();
                }
            }
            catch (InterruptedException e) {
                log.info("ExeRunner.run() got interrupted while waiting for timeout", e);
            }
        }
        return myExecutor.erg;
    }

    static class StreamHandler
    extends Thread {
        private final BufferedReader in;
        private final BufferedWriter out;

        public StreamHandler(BufferedReader in) {
            this(in, new BufferedWriter(new OutputStreamWriter(System.out)));
        }

        public StreamHandler(BufferedReader in, PrintStream out) {
            this(in, new BufferedWriter(new OutputStreamWriter(out)));
        }

        public StreamHandler(BufferedReader in, BufferedWriter out) {
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            try {
                String line = null;
                while ((line = this.in.readLine()) != null) {
                    this.out.write(line);
                    this.out.write("\n");
                }
                this.out.flush();
            }
            catch (IOException e) {
                log.info("StreamHandler got interrupted");
                e.printStackTrace();
            }
        }
    }

    static class BlackHoleStreamHandler
    extends Thread {
        private final BufferedReader in;

        public BlackHoleStreamHandler(BufferedReader in) {
            this.in = in;
        }

        @Override
        public void run() {
            try {
                String line = null;
                while ((line = this.in.readLine()) != null) {
                }
            }
            catch (IOException e) {
                log.info("StreamHandler got interrupted");
                e.printStackTrace();
            }
        }
    }

    private static class ExternalExecutor
    extends Thread {
        final String cmd;
        final String[] cmdArgs;
        final String stdoutFileName;
        final String stderrFileName;
        final String workingDirectory;
        private Process p = null;
        public volatile boolean timeout = false;
        public int erg = -1;

        public ExternalExecutor(String cmd, String stdoutFileName, String workingDirectory) {
            this.cmd = cmd;
            this.cmdArgs = null;
            this.stdoutFileName = stdoutFileName;
            this.workingDirectory = workingDirectory;
            this.stderrFileName = stdoutFileName != null ? (stdoutFileName.endsWith(".log") ? stdoutFileName.substring(0, stdoutFileName.length() - 4) + ".err" : stdoutFileName + ".err") : null;
        }

        public ExternalExecutor(String[] cmdArgs, String stdoutFileName, String workingDirectory) {
            this.cmdArgs = cmdArgs;
            this.cmd = null;
            this.stdoutFileName = stdoutFileName;
            this.workingDirectory = workingDirectory;
            this.stderrFileName = stdoutFileName != null ? (stdoutFileName.endsWith(".log") ? stdoutFileName.substring(0, stdoutFileName.length() - 4) + ".err" : stdoutFileName + ".err") : null;
        }

        public void killProcess() {
            if (this.p != null) {
                this.p.destroy();
            }
        }

        @Override
        public void run() {
            try {
                if (this.workingDirectory == null) {
                    if (this.cmd != null) {
                        this.p = Runtime.getRuntime().exec(this.cmd);
                    } else if (this.cmdArgs != null) {
                        this.p = Runtime.getRuntime().exec(this.cmdArgs);
                    }
                } else if (this.cmd != null) {
                    this.p = Runtime.getRuntime().exec(this.cmd, null, new File(this.workingDirectory));
                } else if (this.cmdArgs != null) {
                    this.p = Runtime.getRuntime().exec(this.cmdArgs, null, new File(this.workingDirectory));
                }
                BufferedReader in = new BufferedReader(new InputStreamReader(this.p.getInputStream()));
                BufferedReader err = new BufferedReader(new InputStreamReader(this.p.getErrorStream()));
                BufferedWriter writerIn = null;
                StreamHandler outputHandler = null;
                if (this.stdoutFileName != null) {
                    writerIn = new BufferedWriter(new FileWriter(this.stdoutFileName));
                    outputHandler = new StreamHandler(in, writerIn);
                    outputHandler.start();
                } else {
                    new BlackHoleStreamHandler(in).start();
                }
                BufferedWriter writerErr = null;
                StreamHandler errorHandler = null;
                if (this.stderrFileName != null) {
                    writerErr = new BufferedWriter(new FileWriter(this.stderrFileName));
                    errorHandler = new StreamHandler(err, writerErr);
                    errorHandler.start();
                } else {
                    new BlackHoleStreamHandler(err).start();
                }
                log.info("Starting external exe with command: " + (this.cmd != null ? this.cmd : Arrays.toString(this.cmdArgs)));
                log.info("Output of the externel exe is written to: " + this.stdoutFileName);
                boolean processRunning = true;
                while (processRunning && !this.timeout) {
                    try {
                        this.p.waitFor();
                        this.erg = this.p.exitValue();
                        log.info("external exe returned " + this.erg);
                        processRunning = false;
                    }
                    catch (InterruptedException e) {
                        log.info("Thread waiting for external exe to finish was interrupted");
                        this.erg = -3;
                    }
                }
                if (this.timeout) {
                    log.info("Timeout reached, killing process...");
                    this.killProcess();
                }
                if (outputHandler != null) {
                    try {
                        outputHandler.join();
                    }
                    catch (InterruptedException e) {
                        log.info("got interrupted while waiting for outputHandler to die.", e);
                    }
                }
                if (errorHandler != null) {
                    try {
                        errorHandler.join();
                    }
                    catch (InterruptedException e) {
                        log.info("got interrupted while waiting for errorHandler to die.", e);
                    }
                }
                if (writerIn != null) {
                    writerIn.flush();
                    writerIn.close();
                }
                if (writerErr != null) {
                    writerErr.flush();
                    writerErr.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.erg = -2;
            }
        }
    }
}

