/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.misc;

import org.apache.log4j.Logger;

public class IntegerCache {
    private static final Logger log = Logger.getLogger(IntegerCache.class);
    private static final int MIN_VALUE = 0;
    private static final int MAX_VALUE = 8192;
    private static boolean initialized = false;
    private static Integer[] cache;

    public static Integer getInteger(int i) {
        if (!initialized) {
            IntegerCache.init();
        }
        if (i < 8192 && i >= 0) {
            return cache[i + 0];
        }
        return i;
    }

    private static synchronized void init() {
        if (initialized) {
            log.warn("IntegerCache has already been initialized.");
            return;
        }
        log.info("Initializing IntegerCache ...");
        cache = new Integer[8192];
        for (int i = 0; i < 8192; ++i) {
            IntegerCache.cache[i] = i - 0;
        }
        log.info("done.");
        initialized = true;
    }
}

