/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.utils.misc;

import org.matsim.core.utils.misc.StringUtils;

public class Time {
    @Deprecated
    public static final double UNDEFINED_TIME = Double.NEGATIVE_INFINITY;
    public static final double MIDNIGHT = 86400.0;
    public static final String TIMEFORMAT_HHMM = "HH:mm";
    public static final String TIMEFORMAT_HHMMSS = "HH:mm:ss";
    public static final String TIMEFORMAT_SSSS = "ssss";
    public static final String TIMEFORMAT_HHMMSSDOTSS = "HH:mm:ss.ss";
    private static String defaultTimeFormat;
    private static final String[] timeElements;

    private Time() {
    }

    public static boolean isUndefinedTime(double time) {
        return time == Double.NEGATIVE_INFINITY;
    }

    public static double getUndefinedTime() {
        return Double.NEGATIVE_INFINITY;
    }

    public static double getVeryLargeTime() {
        return 9.223372036854776E18;
    }

    public static final void setDefaultTimeFormat(String format) {
        defaultTimeFormat = format;
    }

    public static final String writeTime(double seconds, String timeformat) {
        return Time.writeTime(seconds, timeformat, ':');
    }

    public static final String writeTime(double seconds, char separator) {
        return Time.writeTime(seconds, defaultTimeFormat, separator);
    }

    public static final String writeTime(double seconds) {
        return Time.writeTime(seconds, defaultTimeFormat, ':');
    }

    public static final String writeTime(double seconds, String timeformat, char separator) {
        if (TIMEFORMAT_SSSS.equals(timeformat)) {
            return Long.toString((long)seconds);
        }
        if (seconds < 0.0) {
            if (seconds == Double.NEGATIVE_INFINITY) {
                return "undefined";
            }
            return "-" + Time.writeTime(Math.abs(seconds), timeformat, separator);
        }
        double s2 = seconds;
        long h2 = (long)(s2 / 3600.0);
        int m3 = (int)((s2 %= 3600.0) / 60.0);
        s2 %= 60.0;
        StringBuilder str = new StringBuilder(10);
        if (h2 < (long)timeElements.length) {
            str.append(timeElements[(int)h2]);
        } else {
            str.append(Long.toString(h2));
        }
        str.append(separator);
        str.append(timeElements[m3]);
        if (TIMEFORMAT_HHMM.equals(timeformat)) {
            return str.toString();
        }
        if (TIMEFORMAT_HHMMSS.equals(timeformat)) {
            str.append(separator);
            str.append(timeElements[(int)s2]);
            return str.toString();
        }
        if (TIMEFORMAT_HHMMSSDOTSS.equals(timeformat)) {
            str.append(separator);
            if (s2 < 10.0) {
                str.append("0");
            }
            str.append(s2);
            return str.toString();
        }
        throw new IllegalArgumentException("The time format (" + timeformat + ") is not known.");
    }

    public static final double parseTime(String time) {
        return Time.parseTime(time, ':');
    }

    public static final double parseTime(String time, char separator) {
        if (time == null || time.length() == 0 || time.equals("undefined")) {
            return Double.NEGATIVE_INFINITY;
        }
        boolean isNegative = time.charAt(0) == '-';
        String[] strings = isNegative ? StringUtils.explode(time.substring(1), separator) : StringUtils.explode(time, separator);
        double seconds = 0.0;
        if (strings.length == 1) {
            seconds = Math.abs(Double.parseDouble(strings[0]));
        } else if (strings.length == 2) {
            long h2 = Long.parseLong(strings[0]);
            int m3 = Integer.parseInt(strings[1]);
            if (m3 < 0 || m3 > 59) {
                throw new IllegalArgumentException("minutes are out of range in " + time);
            }
            seconds = Math.abs(h2) * 3600L + (long)(m3 * 60);
        } else if (strings.length == 3) {
            long h3 = Long.parseLong(strings[0]);
            int m4 = Integer.parseInt(strings[1]);
            double s2 = Double.parseDouble(strings[2]);
            if (m4 < 0 || m4 > 59) {
                throw new IllegalArgumentException("minutes are out of range in " + time);
            }
            if (s2 < 0.0 || s2 >= 60.0) {
                throw new IllegalArgumentException("seconds are out of range in " + time);
            }
            seconds = (double)(Math.abs(h3) * 3600L + (long)(m4 * 60)) + s2;
        } else {
            throw new IllegalArgumentException("time format is not valid in " + time);
        }
        if (isNegative) {
            seconds = -seconds;
        }
        return seconds;
    }

    public static double convertHHMMInteger(int hhmm) {
        int h2 = hhmm / 100;
        int m3 = hhmm - h2 * 100;
        double seconds = Math.abs(h2) * 3600 + m3 * 60;
        return seconds;
    }

    static {
        int i;
        defaultTimeFormat = TIMEFORMAT_HHMMSS;
        timeElements = new String[60];
        for (i = 0; i < 10; ++i) {
            Time.timeElements[i] = "0" + i;
        }
        for (i = 10; i < 60; ++i) {
            Time.timeElements[i] = Integer.toString(i);
        }
    }
}

