/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.counts;

import java.util.List;
import org.matsim.counts.CountSimComparison;

public class ComparisonErrorStatsCalculator {
    private double[] meanNormRelError = new double[24];
    private double[] meanRelError = new double[24];
    private double[] meanAbsError = new double[24];
    private double[] meanBias = new double[24];
    private int[] numValues = new int[24];

    public ComparisonErrorStatsCalculator(List<CountSimComparison> ccl) {
        for (CountSimComparison cc : ccl) {
            int hour;
            int n = hour = cc.getHour() - 1;
            this.numValues[n] = this.numValues[n] + 1;
            int n2 = hour;
            this.meanNormRelError[n2] = this.meanNormRelError[n2] + cc.calculateNormalizedRelativeError();
            int n3 = hour;
            this.meanRelError[n3] = this.meanRelError[n3] + Math.abs(cc.calculateRelativeError());
            int n4 = hour;
            this.meanAbsError[n4] = this.meanAbsError[n4] + Math.abs(cc.getSimulationValue() - cc.getCountValue());
            int n5 = hour;
            this.meanBias[n5] = this.meanBias[n5] + (cc.getSimulationValue() - cc.getCountValue());
        }
        for (int h2 = 0; h2 < 24; ++h2) {
            if (this.numValues[h2] > 0) {
                int n = h2;
                this.meanNormRelError[n] = this.meanNormRelError[n] / (double)this.numValues[h2];
                int n6 = h2;
                this.meanRelError[n6] = this.meanRelError[n6] / (double)this.numValues[h2];
                int n7 = h2;
                this.meanAbsError[n7] = this.meanAbsError[n7] / (double)this.numValues[h2];
                int n8 = h2;
                this.meanBias[n8] = this.meanBias[n8] / (double)this.numValues[h2];
                continue;
            }
            this.meanNormRelError[h2] = Double.NaN;
            this.meanRelError[h2] = 1000.0;
            this.meanAbsError[h2] = 1.0;
            this.meanBias[h2] = 1.0;
        }
    }

    public double[] getMeanNormRelError() {
        if (this.meanNormRelError == null) {
            throw new RuntimeException("Object not initialized correctly. Call calculateErrorStats(..) first!");
        }
        return (double[])this.meanNormRelError.clone();
    }

    public double[] getMeanRelError() {
        if (this.meanRelError == null) {
            throw new RuntimeException("Object not initialized correctly. Call calculateErrorStats(..) first!");
        }
        return (double[])this.meanRelError.clone();
    }

    public double[] getMeanAbsError() {
        if (this.meanAbsError == null) {
            throw new RuntimeException("Object not initialized correctly. Call calculateErrorStats(..) first!");
        }
        return (double[])this.meanAbsError.clone();
    }

    public double[] getMeanBias() {
        if (this.meanBias == null) {
            throw new RuntimeException("Object not initialized correctly. Call calculateErrorStats(..) first!");
        }
        return (double[])this.meanBias.clone();
    }
}

