/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.counts;

import java.util.HashMap;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Identifiable;
import org.matsim.counts.Volume;

public class Count<T>
implements Identifiable<T> {
    private final Id<T> linkId;
    private String stationName;
    private final HashMap<Integer, Volume> volumes = new HashMap();
    private Coord coord;

    protected Count(Id<T> linkId2, String stationName) {
        this.linkId = linkId2;
        this.stationName = stationName;
    }

    public final Volume createVolume(int h2, double val) {
        if (h2 < 1) {
            throw new RuntimeException("counts start at 1, not at 0.  If you have a use case where you need to go below one, let us know and we think about it, but so far we had numerous debugging sessions because someone inserted counts at 0.");
        }
        Volume v = new Volume(h2, val);
        this.volumes.put(h2, v);
        return v;
    }

    public final void setCsId(String cs_id) {
        this.stationName = cs_id;
    }

    @Override
    public final Id<T> getId() {
        return this.linkId;
    }

    public final String getCsLabel() {
        return this.stationName;
    }

    public final Volume getMaxVolume() {
        Volume v_max = null;
        double max = -1.0;
        for (Volume v : this.volumes.values()) {
            if (!(v.getValue() > max)) continue;
            max = v.getValue();
            v_max = v;
        }
        return v_max;
    }

    public final Volume getVolume(int h2) {
        return this.volumes.get(h2);
    }

    public final HashMap<Integer, Volume> getVolumes() {
        return this.volumes;
    }

    public void setCoord(Coord coord) {
        this.coord = coord;
    }

    public Coord getCoord() {
        return this.coord;
    }

    public final String toString() {
        return "[Loc_id=" + this.linkId + "]" + "[cs_id=" + this.stationName + "]" + "[nof_volumes=" + this.volumes.size() + "]";
    }
}

