/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.counts;

import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.counts.CountSimComparison;

public class CountSimComparisonImpl
implements CountSimComparison {
    private final int hour;
    private final double countValue;
    private final double simulationValue;
    private final Id<Link> id;
    private final String csId;

    @Deprecated
    public CountSimComparisonImpl(Id<Link> id, int hour, double countValue, double simValue) {
        this.id = id;
        this.csId = null;
        this.hour = hour;
        this.countValue = countValue;
        this.simulationValue = simValue;
    }

    public CountSimComparisonImpl(Id<Link> id, String csId, int hour, double countValue, double simValue) {
        this.id = id;
        this.csId = csId;
        this.hour = hour;
        this.countValue = countValue;
        this.simulationValue = simValue;
    }

    @Override
    public String getCsId() {
        return this.csId;
    }

    @Override
    public double calculateRelativeError() {
        double count = this.getCountValue();
        double sim = this.getSimulationValue();
        if (count > 0.0) {
            return Math.min((sim - count) / count, 1000.0);
        }
        if (sim > 0.0) {
            return 1000.0;
        }
        return 0.0;
    }

    @Override
    public double getCountValue() {
        return this.countValue;
    }

    @Override
    public int getHour() {
        return this.hour;
    }

    public Id<Link> getId() {
        return this.id;
    }

    @Override
    public double getSimulationValue() {
        return this.simulationValue;
    }

    @Override
    public double calculateNormalizedRelativeError() {
        double max = Math.max(this.simulationValue, this.countValue);
        if (max == 0.0) {
            return 0.0;
        }
        return Math.abs(this.simulationValue - this.countValue) / max;
    }

    @Override
    public double calculateGEHValue() {
        double diff = this.simulationValue - this.countValue;
        double sum = this.simulationValue + this.countValue;
        double gehV = Math.sqrt(2.0 * diff * diff / sum);
        return gehV;
    }
}

