/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.counts;

import java.util.TreeMap;
import org.matsim.api.core.v01.Id;
import org.matsim.counts.Count;

public class Counts<T> {
    public static final String ELEMENT_NAME = "counts";
    private String name = null;
    private String desc = null;
    private int year = 0;
    private final TreeMap<Id<T>, Count<T>> counts = new TreeMap();

    public final Count<T> createAndAddCount(Id<T> linkId, String stationName) {
        if (this.counts.containsKey(linkId)) {
            throw new RuntimeException("There is already a counts object for location " + linkId);
        }
        Count<T> c = new Count<T>(linkId, stationName);
        this.counts.put(linkId, c);
        return c;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final void setDescription(String desc) {
        this.desc = desc;
    }

    public final void setYear(int year) {
        this.year = year;
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescription() {
        return this.desc;
    }

    public final int getYear() {
        return this.year;
    }

    public final TreeMap<Id<T>, Count<T>> getCounts() {
        return this.counts;
    }

    public final Count<T> getCount(Id<T> locId) {
        return this.counts.get(locId);
    }

    public final String toString() {
        return "[name=" + this.name + "]" + "[nof_counts=" + this.counts.size() + "]";
    }
}

