/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.counts;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.matsim.analysis.IterationStopWatch;
import org.matsim.analysis.VolumesAnalyzer;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.core.config.groups.ControlerConfigGroup;
import org.matsim.core.config.groups.CountsConfigGroup;
import org.matsim.core.config.groups.GlobalConfigGroup;
import org.matsim.core.controler.OutputDirectoryHierarchy;
import org.matsim.core.controler.events.IterationEndsEvent;
import org.matsim.core.controler.events.StartupEvent;
import org.matsim.core.controler.listener.IterationEndsListener;
import org.matsim.core.controler.listener.StartupListener;
import org.matsim.core.utils.collections.CollectionUtils;
import org.matsim.core.utils.geometry.transformations.TransformationFactory;
import org.matsim.counts.CountSimComparison;
import org.matsim.counts.Counts;
import org.matsim.counts.CountsWriter;
import org.matsim.counts.algorithms.CountSimComparisonKMLWriter;
import org.matsim.counts.algorithms.CountSimComparisonTableWriter;
import org.matsim.counts.algorithms.CountsComparisonAlgorithm;
import org.matsim.counts.algorithms.CountsHtmlAndGraphsWriter;
import org.matsim.counts.algorithms.graphs.CountsErrorGraphCreator;
import org.matsim.counts.algorithms.graphs.CountsLoadCurveGraphCreator;
import org.matsim.counts.algorithms.graphs.CountsSimReal24GraphCreator;
import org.matsim.counts.algorithms.graphs.CountsSimRealPerHourGraphCreator;

class CountsControlerListener
implements StartupListener,
IterationEndsListener {
    public static final String OPERATION_COMPARECOUNTS = "compare with counts";
    private GlobalConfigGroup globalConfigGroup;
    private Network network;
    private ControlerConfigGroup controlerConfigGroup;
    private final CountsConfigGroup config;
    private final Set<String> analyzedModes;
    private final VolumesAnalyzer volumesAnalyzer;
    private final IterationStopWatch iterationStopwatch;
    private final OutputDirectoryHierarchy controlerIO;
    @Inject(optional=true)
    private Counts<Link> counts = null;
    private final Map<Id<Link>, double[]> linkStats = new HashMap<Id<Link>, double[]>();
    private int iterationsUsed = 0;

    @javax.inject.Inject
    CountsControlerListener(GlobalConfigGroup globalConfigGroup, Network network, ControlerConfigGroup controlerConfigGroup, CountsConfigGroup countsConfigGroup, VolumesAnalyzer volumesAnalyzer, IterationStopWatch iterationStopwatch, OutputDirectoryHierarchy controlerIO) {
        this.globalConfigGroup = globalConfigGroup;
        this.network = network;
        this.controlerConfigGroup = controlerConfigGroup;
        this.config = countsConfigGroup;
        this.volumesAnalyzer = volumesAnalyzer;
        this.analyzedModes = CollectionUtils.stringToSet(this.config.getAnalyzedModes());
        this.iterationStopwatch = iterationStopwatch;
        this.controlerIO = controlerIO;
    }

    @Override
    public void notifyStartup(StartupEvent controlerStartupEvent) {
        if (this.counts != null) {
            for (Id<Link> linkId : this.counts.getCounts().keySet()) {
                this.linkStats.put(linkId, new double[24]);
            }
        }
    }

    @Override
    public void notifyIterationEnds(IterationEndsEvent event) {
        if (this.counts != null && this.config.getWriteCountsInterval() > 0) {
            if (this.useVolumesOfIteration(event.getIteration(), this.controlerConfigGroup.getFirstIteration())) {
                this.addVolumes(this.volumesAnalyzer);
            }
            if (this.createCountsInIteration(event.getIteration())) {
                String filename;
                Object totalVolumesPerHour;
                Map<Id<Link>, double[]> averages;
                this.iterationStopwatch.beginOperation(OPERATION_COMPARECOUNTS);
                if (this.iterationsUsed > 1) {
                    averages = new HashMap<Id<Link>, double[]>();
                    for (Map.Entry<Id<Link>, double[]> e : this.linkStats.entrySet()) {
                        Id<Link> linkId = e.getKey();
                        totalVolumesPerHour = e.getValue();
                        double[] averageVolumesPerHour = new double[((double[])totalVolumesPerHour).length];
                        for (int i = 0; i < ((double[])totalVolumesPerHour).length; ++i) {
                            averageVolumesPerHour[i] = totalVolumesPerHour[i] / (double)this.iterationsUsed;
                        }
                        averages.put(linkId, averageVolumesPerHour);
                    }
                } else {
                    averages = this.linkStats;
                }
                CountsComparisonAlgorithm cca = new CountsComparisonAlgorithm(averages, this.counts, this.network, this.config.getCountsScaleFactor());
                if (this.config.getDistanceFilter() != null && this.config.getDistanceFilterCenterNode() != null) {
                    cca.setDistanceFilter(this.config.getDistanceFilter(), this.config.getDistanceFilterCenterNode());
                }
                cca.setCountsScaleFactor(this.config.getCountsScaleFactor());
                cca.run();
                if (this.config.getOutputFormat().contains("html") || this.config.getOutputFormat().contains("all")) {
                    CountsHtmlAndGraphsWriter cgw = new CountsHtmlAndGraphsWriter(this.controlerIO.getIterationPath(event.getIteration()), cca.getComparison(), event.getIteration());
                    cgw.addGraphsCreator(new CountsSimRealPerHourGraphCreator("sim and real volumes"));
                    cgw.addGraphsCreator(new CountsErrorGraphCreator("errors"));
                    cgw.addGraphsCreator(new CountsLoadCurveGraphCreator("link volumes"));
                    cgw.addGraphsCreator(new CountsSimReal24GraphCreator("average working day sim and count volumes"));
                    cgw.createHtmlAndGraphs();
                }
                if (this.config.getOutputFormat().contains("kml") || this.config.getOutputFormat().contains("all")) {
                    filename = this.controlerIO.getIterationFilename(event.getIteration(), "countscompare.kmz");
                    CountSimComparisonKMLWriter kmlWriter = new CountSimComparisonKMLWriter(cca.getComparison(), this.network, TransformationFactory.getCoordinateTransformation(this.globalConfigGroup.getCoordinateSystem(), "WGS84"));
                    kmlWriter.setIterationNumber(event.getIteration());
                    kmlWriter.writeFile(filename);
                }
                if (this.config.getOutputFormat().contains("txt") || this.config.getOutputFormat().contains("all")) {
                    filename = this.controlerIO.getIterationFilename(event.getIteration(), "countscompare.txt");
                    CountSimComparisonTableWriter ctw = new CountSimComparisonTableWriter(cca.getComparison(), Locale.ENGLISH);
                    ctw.writeFile(filename);
                }
                if (this.config.getOutputFormat().contains("xml") || this.config.getOutputFormat().contains("all")) {
                    filename = this.controlerIO.getIterationFilename(event.getIteration(), "simulatedCounts.xml.gz");
                    Counts simCounts = new Counts();
                    simCounts.setDescription("sim values from iteration " + event.getIteration());
                    simCounts.setName("sim values from iteration " + event.getIteration());
                    simCounts.setYear(event.getIteration());
                    totalVolumesPerHour = cca.getComparison().iterator();
                    while (totalVolumesPerHour.hasNext()) {
                        CountSimComparison countSimComparison = (CountSimComparison)totalVolumesPerHour.next();
                        if (simCounts.getCount(countSimComparison.getId()) == null) {
                            simCounts.createAndAddCount(countSimComparison.getId(), this.counts.getCount(countSimComparison.getId()).getCsLabel());
                            simCounts.getCount(countSimComparison.getId()).setCoord(this.counts.getCount(countSimComparison.getId()).getCoord());
                        }
                        simCounts.getCount(countSimComparison.getId()).createVolume(countSimComparison.getHour(), countSimComparison.getSimulationValue());
                    }
                    CountsWriter countsWriter = new CountsWriter(TransformationFactory.getCoordinateTransformation(this.globalConfigGroup.getCoordinateSystem(), "WGS84"), simCounts);
                    countsWriter.write(filename);
                }
                this.reset();
                this.iterationStopwatch.endOperation(OPERATION_COMPARECOUNTS);
            }
        }
    }

    boolean useVolumesOfIteration(int iteration, int firstIteration) {
        int iterationMod = iteration % this.config.getWriteCountsInterval();
        int effectiveIteration = iteration - firstIteration;
        int averaging = Math.min(this.config.getAverageCountsOverIterations(), this.config.getWriteCountsInterval());
        if (iterationMod == 0) {
            return this.config.getAverageCountsOverIterations() <= 1 || effectiveIteration >= averaging;
        }
        return iterationMod > this.config.getWriteCountsInterval() - this.config.getAverageCountsOverIterations() && effectiveIteration + (this.config.getWriteCountsInterval() - iterationMod) >= averaging;
    }

    boolean createCountsInIteration(int iteration) {
        return iteration % this.config.getWriteCountsInterval() == 0 && this.iterationsUsed >= this.config.getAverageCountsOverIterations();
    }

    private void addVolumes(VolumesAnalyzer volumes) {
        ++this.iterationsUsed;
        for (Map.Entry<Id<Link>, double[]> e : this.linkStats.entrySet()) {
            Id<Link> linkId = e.getKey();
            double[] volumesPerHour = e.getValue();
            double[] newVolume = this.getVolumesPerHourForLink(volumes, linkId);
            for (int i = 0; i < 24; ++i) {
                int n = i;
                volumesPerHour[n] = volumesPerHour[n] + newVolume[i];
            }
        }
    }

    private double[] getVolumesPerHourForLink(VolumesAnalyzer volumes, Id<Link> linkId) {
        if (this.config.isFilterModes()) {
            double[] newVolume = new double[24];
            for (String mode : this.analyzedModes) {
                double[] volumesForMode = volumes.getVolumesPerHourForLink(linkId, mode);
                if (volumesForMode == null) continue;
                for (int i = 0; i < 24; ++i) {
                    int n = i;
                    newVolume[n] = newVolume[n] + volumesForMode[i];
                }
            }
            return newVolume;
        }
        return volumes.getVolumesPerHourForLink(linkId);
    }

    private void reset() {
        this.iterationsUsed = 0;
        for (double[] hours : this.linkStats.values()) {
            for (int i = 0; i < hours.length; ++i) {
                hours[i] = 0.0;
            }
        }
    }
}

