/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.counts;

import com.google.inject.Provides;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Link;
import org.matsim.core.config.groups.CountsConfigGroup;
import org.matsim.core.controler.AbstractModule;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.geometry.transformations.TransformationFactory;
import org.matsim.counts.Counts;
import org.matsim.counts.CountsControlerListener;
import org.matsim.counts.MatsimCountsReader;

public class CountsModule
extends AbstractModule {
    private static final Logger log = Logger.getLogger(CountsModule.class);

    @Override
    public void install() {
        this.addControlerListenerBinding().to(CountsControlerListener.class);
        this.bind(CountsInitializer.class).asEagerSingleton();
    }

    @Provides
    @Singleton
    Counts<Link> provideLinkCounts(Scenario scenario, CountsConfigGroup config) {
        Counts<Link> counts = (Counts<Link>)scenario.getScenarioElement("counts");
        if (counts != null) {
            return counts;
        }
        counts = new Counts<Link>();
        if (config.getCountsFileName() != null) {
            MatsimCountsReader counts_parser;
            String inputCRS = config.getInputCRS();
            String internalCRS = scenario.getConfig().global().getCoordinateSystem();
            if (inputCRS == null) {
                counts_parser = new MatsimCountsReader(counts);
            } else {
                log.info("re-projecting counts from " + inputCRS + " to " + internalCRS + " for import");
                CoordinateTransformation transformation = TransformationFactory.getCoordinateTransformation(inputCRS, internalCRS);
                counts_parser = new MatsimCountsReader(transformation, counts);
            }
            counts_parser.parse(config.getCountsFileURL(scenario.getConfig().getContext()));
        }
        return counts;
    }

    private static class CountsInitializer {
        @Inject
        CountsInitializer(Counts<Link> counts, Scenario scenario) {
            Counts scenarioCounts = (Counts)scenario.getScenarioElement("counts");
            if (scenarioCounts == null) {
                scenario.addScenarioElement("counts", counts);
            } else if (counts != scenarioCounts) {
                throw new RuntimeException();
            }
        }
    }
}

