/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.counts;

import java.util.Stack;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.geometry.transformations.IdentityTransformation;
import org.matsim.core.utils.io.MatsimXmlParser;
import org.matsim.counts.Count;
import org.matsim.counts.Counts;
import org.xml.sax.Attributes;

public class CountsReaderMatsimV1
extends MatsimXmlParser {
    private static final String COUNTS = "counts";
    private static final String COUNT = "count";
    private static final String VOLUME = "volume";
    private final CoordinateTransformation coordinateTransformation;
    private final Counts counts;
    private Count currcount = null;
    private static final Logger log = Logger.getLogger(CountsReaderMatsimV1.class);

    public CountsReaderMatsimV1(Counts counts) {
        this(new IdentityTransformation(), counts);
    }

    public CountsReaderMatsimV1(CoordinateTransformation coordinateTransformation, Counts counts) {
        this.coordinateTransformation = coordinateTransformation;
        this.counts = counts;
    }

    @Override
    public void startTag(String name, Attributes atts, Stack<String> context) {
        if (VOLUME.equals(name)) {
            this.startVolume(atts);
        } else if (COUNT.equals(name)) {
            this.startCount(atts);
        } else if (COUNTS.equals(name)) {
            this.startCounts(atts);
        }
    }

    @Override
    public void endTag(String name, String content, Stack<String> context) {
    }

    private void startCounts(Attributes meta) {
        this.counts.setName(meta.getValue("name"));
        this.counts.setDescription(meta.getValue("desc"));
        this.counts.setYear(Integer.parseInt(meta.getValue("year")));
    }

    private void startCount(Attributes meta) {
        String locId = meta.getValue("loc_id");
        this.currcount = this.counts.createAndAddCount(Id.create(locId, Link.class), meta.getValue("cs_id"));
        String x = meta.getValue("x");
        String y = meta.getValue("y");
        if (x != null && y != null) {
            this.currcount.setCoord(this.coordinateTransformation.transform(new Coord(Double.parseDouble(x), Double.parseDouble(y))));
        }
    }

    private void startVolume(Attributes meta) {
        if (this.currcount != null) {
            this.currcount.createVolume(Integer.parseInt(meta.getValue("h")), Double.parseDouble(meta.getValue("val")));
        }
    }
}

