/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.counts;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import org.matsim.core.api.internal.MatsimWriter;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.geometry.transformations.IdentityTransformation;
import org.matsim.core.utils.io.MatsimXmlWriter;
import org.matsim.counts.Count;
import org.matsim.counts.Counts;
import org.matsim.counts.CountsWriterHandler;
import org.matsim.counts.CountsWriterHandlerImplV1;
import org.matsim.counts.Volume;

public class CountsWriter
extends MatsimXmlWriter
implements MatsimWriter {
    private final CountsWriterHandler handler;
    private final Counts counts;

    public CountsWriter(Counts counts) {
        this(new IdentityTransformation(), counts);
    }

    public CountsWriter(CoordinateTransformation coordinateTransformation, Counts counts) {
        this.counts = counts;
        this.handler = new CountsWriterHandlerImplV1(coordinateTransformation);
    }

    @Override
    public final void write(String filename) {
        try {
            this.openFile(filename);
            this.doTheWriting();
            this.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final void write(OutputStream stream) {
        try {
            this.openOutputStream(stream);
            this.doTheWriting();
            this.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void doTheWriting() throws IOException {
        this.writeXmlHead();
        this.handler.startCounts(this.counts, this.writer);
        this.handler.writeSeparator(this.writer);
        Vector countsTemp = new Vector();
        countsTemp.addAll(this.counts.getCounts().values());
        Collections.sort(countsTemp, new CountComparator());
        for (Count count : countsTemp) {
            Vector<Volume> volumesTemp = new Vector<Volume>();
            volumesTemp.addAll(count.getVolumes().values());
            Collections.sort(volumesTemp, new VolumeComparator());
            this.handler.startCount(count, this.writer);
            for (Volume v : volumesTemp) {
                this.handler.startVolume(v, this.writer);
                this.handler.endVolume(this.writer);
            }
            this.handler.endCount(this.writer);
            this.handler.writeSeparator(this.writer);
            this.writer.flush();
        }
        this.handler.endCounts(this.writer);
    }

    public final String toString() {
        return super.toString();
    }

    static class CountComparator
    implements Comparator<Count>,
    Serializable {
        private static final long serialVersionUID = 1L;

        CountComparator() {
        }

        @Override
        public int compare(Count c1, Count c2) {
            return c1.getCsLabel().compareTo(c2.getCsLabel());
        }
    }

    static class VolumeComparator
    implements Comparator<Volume>,
    Serializable {
        private static final long serialVersionUID = 1L;

        VolumeComparator() {
        }

        @Override
        public int compare(Volume v1, Volume v2) {
            return Double.compare(v1.getHourOfDayStartingWithOne(), v2.getHourOfDayStartingWithOne());
        }
    }
}

