/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.counts;

import java.io.BufferedWriter;
import java.io.IOException;
import org.matsim.api.core.v01.Coord;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.counts.Count;
import org.matsim.counts.Counts;
import org.matsim.counts.CountsWriterHandler;
import org.matsim.counts.Volume;

class CountsWriterHandlerImplV1
implements CountsWriterHandler {
    private final CoordinateTransformation coordinateTransformation;

    CountsWriterHandlerImplV1(CoordinateTransformation coordinateTransformation) {
        this.coordinateTransformation = coordinateTransformation;
    }

    @Override
    public void startCounts(Counts counts, BufferedWriter out) throws IOException {
        out.write("<counts ");
        out.write("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
        out.write("xsi:noNamespaceSchemaLocation=\"http://matsim.org/files/dtd/counts_v1.xsd\"\n");
        if (counts.getName() != null) {
            out.write(" name=\"" + counts.getName() + "\"");
        } else {
            out.write(" name=\"\"");
        }
        if (counts.getDescription() != null) {
            out.write(" desc=\"" + counts.getDescription() + "\"");
        }
        out.write(" year=\"" + counts.getYear() + "\" ");
        out.write(" > \n");
    }

    @Override
    public void endCounts(BufferedWriter out) throws IOException {
        out.write("</counts>\n");
    }

    @Override
    public void startCount(Count count, BufferedWriter out) throws IOException {
        out.write("\t<count");
        out.write(" loc_id=\"" + count.getId() + "\"");
        out.write(" cs_id=\"" + count.getCsLabel() + "\"");
        if (count.getCoord() != null) {
            Coord coord = this.coordinateTransformation.transform(count.getCoord());
            out.write(" x=\"" + coord.getX() + "\"");
            out.write(" y=\"" + coord.getY() + "\"");
        }
        out.write(">\n");
    }

    @Override
    public void endCount(BufferedWriter out) throws IOException {
        out.write("\t</count>\n\n");
    }

    @Override
    public void startVolume(Volume volume, BufferedWriter out) throws IOException {
        out.write("\t\t<volume");
        out.write(" h=\"" + volume.getHourOfDayStartingWithOne() + "\"");
        out.write(" val=\"" + volume.getValue() + "\"");
        out.write(" />\n");
    }

    @Override
    public void endVolume(BufferedWriter out) throws IOException {
    }

    @Override
    public void writeSeparator(BufferedWriter out) throws IOException {
        out.write("<!-- ====================================================================== -->\n\n");
    }
}

