/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.counts;

import java.util.Stack;
import org.apache.log4j.Logger;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.geometry.transformations.IdentityTransformation;
import org.matsim.core.utils.io.MatsimXmlParser;
import org.matsim.counts.Counts;
import org.matsim.counts.CountsReaderMatsimV1;
import org.xml.sax.Attributes;

public class MatsimCountsReader
extends MatsimXmlParser {
    private static final Logger log = Logger.getLogger(MatsimCountsReader.class);
    private static final String COUNTS_V1 = "counts_v1.xsd";
    private final Counts counts;
    private MatsimXmlParser delegate = null;
    private final CoordinateTransformation coordinateTransformation;

    public MatsimCountsReader(Counts counts) {
        this(new IdentityTransformation(), counts);
    }

    public MatsimCountsReader(CoordinateTransformation coordinateTransformation, Counts counts) {
        this.coordinateTransformation = coordinateTransformation;
        this.counts = counts;
    }

    @Override
    public void startTag(String name, Attributes atts, Stack<String> context) {
        this.delegate.startTag(name, atts, context);
    }

    @Override
    public void endTag(String name, String content, Stack<String> context) {
        this.delegate.endTag(name, content, context);
    }

    @Override
    protected void setDoctype(String doctype) {
        super.setDoctype(doctype);
        if (!COUNTS_V1.equals(doctype)) {
            throw new IllegalArgumentException("Doctype \"" + doctype + "\" not known.");
        }
        this.delegate = new CountsReaderMatsimV1(this.coordinateTransformation, this.counts);
        log.info("using counts_v1-reader.");
    }
}

