/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.counts.algorithms;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.opengis.kml.v_2_2_0.DocumentType;
import net.opengis.kml.v_2_2_0.FolderType;
import net.opengis.kml.v_2_2_0.IconStyleType;
import net.opengis.kml.v_2_2_0.KmlType;
import net.opengis.kml.v_2_2_0.LinkType;
import net.opengis.kml.v_2_2_0.ObjectFactory;
import net.opengis.kml.v_2_2_0.PlacemarkType;
import net.opengis.kml.v_2_2_0.PointType;
import net.opengis.kml.v_2_2_0.ScreenOverlayType;
import net.opengis.kml.v_2_2_0.StyleType;
import net.opengis.kml.v_2_2_0.TimeSpanType;
import net.opengis.kml.v_2_2_0.UnitsEnumType;
import net.opengis.kml.v_2_2_0.Vec2Type;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.core.gbl.MatsimResource;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.io.IOUtils;
import org.matsim.core.utils.misc.Time;
import org.matsim.counts.CountSimComparison;
import org.matsim.counts.Counts;
import org.matsim.counts.algorithms.CountSimComparisonWriter;
import org.matsim.counts.algorithms.graphs.BiasErrorGraph;
import org.matsim.counts.algorithms.graphs.BiasNormalizedErrorGraph;
import org.matsim.counts.algorithms.graphs.BoxPlotErrorGraph;
import org.matsim.counts.algorithms.graphs.BoxPlotNormalizedErrorGraph;
import org.matsim.counts.algorithms.graphs.CountsGEHCurveGraph;
import org.matsim.counts.algorithms.graphs.CountsGEHCurveGraphCreator;
import org.matsim.counts.algorithms.graphs.CountsGraph;
import org.matsim.counts.algorithms.graphs.CountsLoadCurveGraph;
import org.matsim.counts.algorithms.graphs.CountsLoadCurveGraphCreator;
import org.matsim.counts.algorithms.graphs.CountsSimReal24Graph;
import org.matsim.counts.algorithms.graphs.CountsSimRealPerHourGraph;
import org.matsim.vis.kml.KMZWriter;
import org.matsim.vis.kml.MatsimKMLLogo;

public class CountSimComparisonKMLWriter<T>
extends CountSimComparisonWriter {
    private static final String LINK = "Link: ";
    private static final String CSID = "Count Station: ";
    private static final String COUNTVALUE = "Count Value: ";
    private static final String MATSIMVALUE = "MATSim Value: ";
    private static final String RELERROR = "Relative Error: ";
    private static final String NORMRELERROR = "Normalized Relative Error: ";
    private static final String GEH = "GEH: ";
    private static final String IMG = "<img src=\"../";
    private static final String IMGEND = "\">";
    private static final String H24OVERVIEW = "24 h overview";
    private static final String DETAILSFROM = "Details from ";
    private static final String OCLOCKTO = " o'clock to ";
    private static final String OCLOCK = " o'clock";
    private static final String ZERO = "0";
    private static final NumberFormat nf = new DecimalFormat("#.#");
    private static final String CIRCLEICON = "icons/circle.png";
    private static final String CROSSICON = "icons/plus.png";
    private static final String MINUSICON = "icons/minus.png";
    private static final Double ICONSCALE = 0.5;
    private static final int CHARTHEIGHT = 300;
    private static final int CHARTWIDTH = 400;
    private static final String PNG = ".png";
    private final String graphname;
    private final Network network;
    private final Counts<T> counts;
    private CoordinateTransformation coordTransform = null;
    private ObjectFactory kmlObjectFactory = new ObjectFactory();
    private KmlType mainKml = null;
    private DocumentType mainDoc = null;
    private FolderType mainFolder = null;
    private KMZWriter writer = null;
    private StyleType redCircleStyle;
    private StyleType redCrossStyle;
    private StyleType redMinusStyle;
    private StyleType yellowCircleStyle;
    private StyleType yellowCrossStyle;
    private StyleType yellowMinusStyle;
    private StyleType greenMinusStyle;
    private StyleType greenCircleStyle;
    private StyleType greenCrossStyle;
    private StyleType greyCircleStyle;
    private StyleType greyCrossStyle;
    private StyleType greyMinusStyle;
    private Map<String, String> countsLoadCurveGraphMap;
    private Map<String, String> countsGEHCurveGraphMap;
    private static final Logger log = Logger.getLogger(CountSimComparisonKMLWriter.class);

    public CountSimComparisonKMLWriter(List<CountSimComparison> countSimCompList, Network network, CoordinateTransformation coordTransform) {
        super(countSimCompList);
        this.network = network;
        this.counts = null;
        this.coordTransform = coordTransform;
        this.graphname = "countsSimRealPerHour_";
    }

    public CountSimComparisonKMLWriter(List<CountSimComparison> countSimCompList, Counts<T> counts, CoordinateTransformation coordTransform, String graphname) {
        super(countSimCompList);
        this.network = null;
        this.counts = counts;
        this.coordTransform = coordTransform;
        this.graphname = graphname;
    }

    private void createStyles() {
        this.redCircleStyle = this.kmlObjectFactory.createStyleType();
        this.redCircleStyle.setId("redCircleStyle");
        this.redCrossStyle = this.kmlObjectFactory.createStyleType();
        this.redCrossStyle.setId("redCrossStyle");
        this.redMinusStyle = this.kmlObjectFactory.createStyleType();
        this.redMinusStyle.setId("redMinusStyle");
        this.yellowCircleStyle = this.kmlObjectFactory.createStyleType();
        this.yellowCircleStyle.setId("yellowCircleStyle");
        this.yellowCrossStyle = this.kmlObjectFactory.createStyleType();
        this.yellowCrossStyle.setId("yellowCrossStyle");
        this.yellowMinusStyle = this.kmlObjectFactory.createStyleType();
        this.yellowMinusStyle.setId("yellowMinusStyle");
        this.greenCircleStyle = this.kmlObjectFactory.createStyleType();
        this.greenCircleStyle.setId("greenCircleStyle");
        this.greenCrossStyle = this.kmlObjectFactory.createStyleType();
        this.greenCrossStyle.setId("greenCrossStyle");
        this.greenMinusStyle = this.kmlObjectFactory.createStyleType();
        this.greenMinusStyle.setId("greenMinusStyle");
        this.greyCircleStyle = this.kmlObjectFactory.createStyleType();
        this.greyCircleStyle.setId("greyCircleStyle");
        this.greyCrossStyle = this.kmlObjectFactory.createStyleType();
        this.greyCrossStyle.setId("greyCrossStyle");
        this.greyMinusStyle = this.kmlObjectFactory.createStyleType();
        this.greyMinusStyle.setId("greyMinusStyle");
        byte[] red = new byte[]{-1, 15, 15, -66};
        byte[] green = new byte[]{-1, 20, -36, 10};
        byte[] yellow = new byte[]{-1, 20, -26, -26};
        byte[] grey = new byte[]{-1, 66, 66, 66};
        HashMap<StyleType, byte[]> colors = new HashMap<StyleType, byte[]>();
        colors.put(this.redCircleStyle, red);
        colors.put(this.redCrossStyle, red);
        colors.put(this.redMinusStyle, red);
        colors.put(this.yellowCircleStyle, yellow);
        colors.put(this.yellowCrossStyle, yellow);
        colors.put(this.yellowMinusStyle, yellow);
        colors.put(this.greenCircleStyle, green);
        colors.put(this.greenCrossStyle, green);
        colors.put(this.greenMinusStyle, green);
        colors.put(this.greyCircleStyle, grey);
        colors.put(this.greyCrossStyle, grey);
        colors.put(this.greyMinusStyle, grey);
        HashMap<StyleType, String> hrefs = new HashMap<StyleType, String>();
        hrefs.put(this.redCircleStyle, CIRCLEICON);
        hrefs.put(this.redCrossStyle, CROSSICON);
        hrefs.put(this.redMinusStyle, MINUSICON);
        hrefs.put(this.yellowCircleStyle, CIRCLEICON);
        hrefs.put(this.yellowCrossStyle, CROSSICON);
        hrefs.put(this.yellowMinusStyle, MINUSICON);
        hrefs.put(this.greenCircleStyle, CIRCLEICON);
        hrefs.put(this.greenCrossStyle, CROSSICON);
        hrefs.put(this.greenMinusStyle, MINUSICON);
        hrefs.put(this.greyCircleStyle, CIRCLEICON);
        hrefs.put(this.greyCrossStyle, CROSSICON);
        hrefs.put(this.greyMinusStyle, MINUSICON);
        for (StyleType styleType : new StyleType[]{this.redCircleStyle, this.redCrossStyle, this.redMinusStyle, this.yellowCircleStyle, this.yellowCrossStyle, this.yellowMinusStyle, this.greenCircleStyle, this.greenCrossStyle, this.greenMinusStyle, this.greyCircleStyle, this.greyCrossStyle, this.greyMinusStyle}) {
            IconStyleType icon = this.kmlObjectFactory.createIconStyleType();
            icon.setColor(new byte[]{((byte[])colors.get(styleType))[0], ((byte[])colors.get(styleType))[1], ((byte[])colors.get(styleType))[2], ((byte[])colors.get(styleType))[3]});
            icon.setScale(ICONSCALE);
            LinkType link = this.kmlObjectFactory.createLinkType();
            link.setHref((String)hrefs.get(styleType));
            icon.setIcon(link);
            styleType.setIconStyle(icon);
            this.mainDoc.getAbstractStyleSelectorGroup().add(this.kmlObjectFactory.createStyle(styleType));
        }
    }

    @Override
    public void writeFile(String filename) {
        log.info("Writing google earth file to " + filename);
        this.mainKml = this.kmlObjectFactory.createKmlType();
        this.mainDoc = this.kmlObjectFactory.createDocumentType();
        this.mainKml.setAbstractFeatureGroup(this.kmlObjectFactory.createDocument(this.mainDoc));
        this.createStyles();
        this.mainFolder = this.kmlObjectFactory.createFolderType();
        this.mainFolder.setName("Comparison, Iteration " + this.iterationNumber);
        this.mainDoc.getAbstractFeatureGroup().add(this.kmlObjectFactory.createFolder(this.mainFolder));
        this.writer = new KMZWriter(filename);
        try {
            this.mainFolder.getAbstractFeatureGroup().add(this.kmlObjectFactory.createScreenOverlay(this.createLegend()));
            this.mainFolder.getAbstractFeatureGroup().add(this.kmlObjectFactory.createScreenOverlay(this.createLegendNormalized()));
            this.mainFolder.getAbstractFeatureGroup().add(this.kmlObjectFactory.createScreenOverlay(this.createLegendGEH()));
        }
        catch (IOException e) {
            log.error("Cannot add legend to the KMZ file.", e);
        }
        try {
            this.mainFolder.getAbstractFeatureGroup().add(this.kmlObjectFactory.createScreenOverlay(MatsimKMLLogo.writeMatsimKMLLogo(this.writer)));
        }
        catch (IOException e) {
            log.error("Cannot add logo to the KMZ file.", e);
        }
        try {
            this.writer.addNonKMLFile(MatsimResource.getAsInputStream(CIRCLEICON), CIRCLEICON);
            this.writer.addNonKMLFile(MatsimResource.getAsInputStream(CROSSICON), CROSSICON);
            this.writer.addNonKMLFile(MatsimResource.getAsInputStream(MINUSICON), MINUSICON);
        }
        catch (IOException e) {
            log.error("Could not copy copy plus-/minus-icons to the KMZ.", e);
        }
        FolderType simRealFolder = this.kmlObjectFactory.createFolderType();
        simRealFolder.setName("XY Comparison Plots");
        this.mainFolder.getAbstractFeatureGroup().add(this.kmlObjectFactory.createFolder(simRealFolder));
        ScreenOverlayType errorGraph = this.createBiasErrorGraph(filename);
        errorGraph.setVisibility(Boolean.TRUE);
        this.mainFolder.getAbstractFeatureGroup().add(this.kmlObjectFactory.createScreenOverlay(errorGraph));
        errorGraph = this.createBiasNormalizedErrorGraph(filename);
        errorGraph.setVisibility(Boolean.FALSE);
        this.mainFolder.getAbstractFeatureGroup().add(this.kmlObjectFactory.createScreenOverlay(errorGraph));
        errorGraph = this.createBoxPlotErrorGraph();
        if (errorGraph != null) {
            errorGraph.setVisibility(Boolean.FALSE);
            this.mainFolder.getAbstractFeatureGroup().add(this.kmlObjectFactory.createScreenOverlay(errorGraph));
        }
        if ((errorGraph = this.createBoxPlotNormalizedErrorGraph()) != null) {
            errorGraph.setVisibility(Boolean.FALSE);
            this.mainFolder.getAbstractFeatureGroup().add(this.kmlObjectFactory.createScreenOverlay(errorGraph));
        }
        ScreenOverlayType awtv = null;
        try {
            awtv = this.createAWTVGraph();
        }
        catch (Exception ee) {
            log.warn("generating awtv (average weekday traffic volumes) graph failed; printing stacktrace but continuing anyways ...");
            for (int ii = 0; ii < ee.getStackTrace().length; ++ii) {
                log.info(ee.getStackTrace()[ii].toString());
            }
        }
        if (awtv != null) {
            awtv.setVisibility(Boolean.FALSE);
            this.mainFolder.getAbstractFeatureGroup().add(this.kmlObjectFactory.createScreenOverlay(awtv));
        }
        this.createCountsLoadCurveGraphs();
        this.createCountsGEHCurveGraphs();
        FolderType folderRelative = this.kmlObjectFactory.createFolderType();
        folderRelative.setName("Relative Values");
        this.mainFolder.getAbstractFeatureGroup().add(this.kmlObjectFactory.createFolder(folderRelative));
        FolderType folderNormalizedRelative = this.kmlObjectFactory.createFolderType();
        folderNormalizedRelative.setName("Normalized Relative Values");
        folderNormalizedRelative.setVisibility(Boolean.FALSE);
        this.mainFolder.getAbstractFeatureGroup().add(this.kmlObjectFactory.createFolder(folderNormalizedRelative));
        FolderType folderGEH = this.kmlObjectFactory.createFolderType();
        folderGEH.setName("GEH Values");
        folderGEH.setVisibility(Boolean.FALSE);
        this.mainFolder.getAbstractFeatureGroup().add(this.kmlObjectFactory.createFolder(folderGEH));
        for (int h2 = 1; h2 < 25; ++h2) {
            TimeSpanType timespan = this.kmlObjectFactory.createTimeSpanType();
            timespan.setBegin("1999-01-01T" + Time.writeTime((h2 - 1) * 3600));
            timespan.setEnd("1999-01-01T" + Time.writeTime(h2 * 3600));
            this.addCountsSimRealPerHourGraphs(simRealFolder, h2, timespan);
            FolderType subfolderRelative = this.kmlObjectFactory.createFolderType();
            subfolderRelative.setName(this.createFolderName(h2));
            subfolderRelative.setAbstractTimePrimitiveGroup(this.kmlObjectFactory.createTimeSpan(timespan));
            folderRelative.getAbstractFeatureGroup().add(this.kmlObjectFactory.createFolder(subfolderRelative));
            FolderType subfolderNormalizedRelative = this.kmlObjectFactory.createFolderType();
            subfolderNormalizedRelative.setName(this.createFolderName(h2));
            subfolderNormalizedRelative.setAbstractTimePrimitiveGroup(this.kmlObjectFactory.createTimeSpan(timespan));
            folderNormalizedRelative.getAbstractFeatureGroup().add(this.kmlObjectFactory.createFolder(subfolderNormalizedRelative));
            FolderType subfolderGEH = this.kmlObjectFactory.createFolderType();
            subfolderGEH.setName(this.createFolderName(h2));
            subfolderGEH.setAbstractTimePrimitiveGroup(this.kmlObjectFactory.createTimeSpan(timespan));
            subfolderGEH.setVisibility(Boolean.FALSE);
            folderGEH.getAbstractFeatureGroup().add(this.kmlObjectFactory.createFolder(subfolderGEH));
            this.writeLinkData(this.countComparisonFilter.getCountsForHour(h2), subfolderRelative, subfolderNormalizedRelative, subfolderGEH);
        }
        this.finish();
    }

    private String createFolderName(int timestep) {
        StringBuilder buffer = new StringBuilder(30);
        buffer.append("Traffic from ");
        buffer.append(this.timestepToString(timestep - 1));
        buffer.append(" to ");
        buffer.append(this.timestepToString(timestep));
        buffer.append(OCLOCK);
        return buffer.toString();
    }

    private ScreenOverlayType createLegend() throws IOException {
        this.writer.addNonKMLFile(MatsimResource.getAsInputStream("countsKml/countsLegend240x300.png"), "countsLegend.png");
        ScreenOverlayType overlay = this.kmlObjectFactory.createScreenOverlayType();
        LinkType icon = this.kmlObjectFactory.createLinkType();
        icon.setHref("./countsLegend.png");
        overlay.setIcon(icon);
        overlay.setName("Legend");
        Vec2Type overlayXY = this.kmlObjectFactory.createVec2Type();
        overlayXY.setX(0.0);
        overlayXY.setY(0.0);
        overlayXY.setXunits(UnitsEnumType.FRACTION);
        overlayXY.setYunits(UnitsEnumType.FRACTION);
        overlay.setOverlayXY(overlayXY);
        Vec2Type screenXY = this.kmlObjectFactory.createVec2Type();
        screenXY.setX(0.02);
        screenXY.setY(0.07);
        screenXY.setXunits(UnitsEnumType.FRACTION);
        screenXY.setYunits(UnitsEnumType.FRACTION);
        overlay.setScreenXY(screenXY);
        return overlay;
    }

    private ScreenOverlayType createLegendNormalized() throws IOException {
        this.writer.addNonKMLFile(MatsimResource.getAsInputStream("countsKml/countsLegendNormalized.png"), "countsLegendNormalized.png");
        ScreenOverlayType overlay = this.kmlObjectFactory.createScreenOverlayType();
        LinkType icon = this.kmlObjectFactory.createLinkType();
        icon.setHref("./countsLegendNormalized.png");
        overlay.setIcon(icon);
        overlay.setName("Legend Normalized");
        Vec2Type overlayXY = this.kmlObjectFactory.createVec2Type();
        overlayXY.setX(0.0);
        overlayXY.setY(0.0);
        overlayXY.setXunits(UnitsEnumType.FRACTION);
        overlayXY.setYunits(UnitsEnumType.FRACTION);
        overlay.setOverlayXY(overlayXY);
        Vec2Type screenXY = this.kmlObjectFactory.createVec2Type();
        screenXY.setX(0.02);
        screenXY.setY(0.07);
        screenXY.setXunits(UnitsEnumType.FRACTION);
        screenXY.setYunits(UnitsEnumType.FRACTION);
        overlay.setScreenXY(screenXY);
        overlay.setVisibility(Boolean.FALSE);
        return overlay;
    }

    private ScreenOverlayType createLegendGEH() throws IOException {
        this.writer.addNonKMLFile(MatsimResource.getAsInputStream("countsKml/countsLegendGEH.png"), "countsLegendGEH.png");
        ScreenOverlayType overlay = this.kmlObjectFactory.createScreenOverlayType();
        LinkType icon = this.kmlObjectFactory.createLinkType();
        icon.setHref("./countsLegendGEH.png");
        overlay.setIcon(icon);
        overlay.setName("Legend GEH");
        Vec2Type overlayXY = this.kmlObjectFactory.createVec2Type();
        overlayXY.setX(0.0);
        overlayXY.setY(0.0);
        overlayXY.setXunits(UnitsEnumType.FRACTION);
        overlayXY.setYunits(UnitsEnumType.FRACTION);
        overlay.setOverlayXY(overlayXY);
        Vec2Type screenXY = this.kmlObjectFactory.createVec2Type();
        screenXY.setX(0.02);
        screenXY.setY(0.07);
        screenXY.setXunits(UnitsEnumType.FRACTION);
        screenXY.setYunits(UnitsEnumType.FRACTION);
        overlay.setScreenXY(screenXY);
        overlay.setVisibility(Boolean.FALSE);
        return overlay;
    }

    private PlacemarkType createPlacemark(String linkid, CountSimComparison csc, double relativeError, double normalizedRelativeError, double gehValue, int timestep, String imagePath) {
        PlacemarkType placemark = this.kmlObjectFactory.createPlacemarkType();
        placemark.setDescription(this.createPlacemarkDescription(linkid, csc, relativeError, normalizedRelativeError, gehValue, timestep, imagePath));
        return placemark;
    }

    private void writeLinkData(List<CountSimComparison> countSimComparisonList, FolderType folder, FolderType folderNormalized, FolderType folderGEH) {
        for (CountSimComparison csc : countSimComparisonList) {
            Id itemId = csc.getId();
            Coord coord = null;
            if (this.counts == null) {
                Link link = this.network.getLinks().get(itemId);
                coord = this.coordTransform.transform(this.calculatePlacemarkPosition(link));
            } else {
                coord = this.coordTransform.transform(this.counts.getCount(itemId).getCoord());
            }
            double relativeError = csc.calculateRelativeError();
            double normalizedRelativeError = csc.calculateNormalizedRelativeError();
            double gehValue = csc.calculateGEHValue();
            PlacemarkType placemark = this.createPlacemark(itemId.toString(), csc, relativeError, normalizedRelativeError, gehValue, csc.getHour(), this.countsLoadCurveGraphMap.get(itemId.toString()));
            PointType point = this.kmlObjectFactory.createPointType();
            point.getCoordinates().add(Double.toString(coord.getX()) + "," + Double.toString(coord.getY()) + ",0.0");
            placemark.setAbstractGeometryGroup(this.kmlObjectFactory.createPoint(point));
            if (csc.getSimulationValue() > csc.getCountValue()) {
                if (csc.getSimulationValue() < csc.getCountValue() * 1.5) {
                    placemark.setStyleUrl(this.greenCrossStyle.getId());
                } else if (csc.getSimulationValue() < csc.getCountValue() * 2.0) {
                    placemark.setStyleUrl(this.yellowCrossStyle.getId());
                } else {
                    placemark.setStyleUrl(this.redCrossStyle.getId());
                }
            } else if (csc.getSimulationValue() > csc.getCountValue() * 0.75) {
                placemark.setStyleUrl("#greenMinusStyle");
            } else if (csc.getSimulationValue() > csc.getCountValue() * 0.5) {
                placemark.setStyleUrl("#yellowMinusStyle");
            } else {
                placemark.setStyleUrl("#redMinusStyle");
            }
            folder.getAbstractFeatureGroup().add(this.kmlObjectFactory.createPlacemark(placemark));
            placemark = this.createPlacemark(itemId.toString(), csc, relativeError, normalizedRelativeError, gehValue, csc.getHour(), this.countsLoadCurveGraphMap.get(itemId.toString()));
            placemark.setVisibility(Boolean.FALSE);
            point = this.kmlObjectFactory.createPointType();
            point.getCoordinates().add(Double.toString(coord.getX()) + "," + Double.toString(coord.getY()) + ",0.0");
            placemark.setAbstractGeometryGroup(this.kmlObjectFactory.createPoint(point));
            if (normalizedRelativeError <= 0.1) {
                placemark.setStyleUrl(this.greenCircleStyle.getId());
            } else if (normalizedRelativeError <= 0.25) {
                if (csc.getSimulationValue() > csc.getCountValue()) {
                    placemark.setStyleUrl(this.greenCrossStyle.getId());
                } else {
                    placemark.setStyleUrl(this.greenMinusStyle.getId());
                }
            } else if (normalizedRelativeError <= 0.5) {
                if (csc.getSimulationValue() > csc.getCountValue()) {
                    placemark.setStyleUrl(this.yellowCrossStyle.getId());
                } else {
                    placemark.setStyleUrl(this.yellowMinusStyle.getId());
                }
            } else if (normalizedRelativeError <= 1.0) {
                if (csc.getSimulationValue() > csc.getCountValue()) {
                    placemark.setStyleUrl(this.redCrossStyle.getId());
                } else {
                    placemark.setStyleUrl(this.redMinusStyle.getId());
                }
            } else {
                placemark.setStyleUrl(this.greyCircleStyle.getId());
            }
            folderNormalized.getAbstractFeatureGroup().add(this.kmlObjectFactory.createPlacemark(placemark));
            placemark = this.createPlacemark(itemId.toString(), csc, relativeError, normalizedRelativeError, gehValue, csc.getHour(), this.countsGEHCurveGraphMap.get(itemId.toString()));
            placemark.setVisibility(Boolean.FALSE);
            point = this.kmlObjectFactory.createPointType();
            point.getCoordinates().add(Double.toString(coord.getX()) + "," + Double.toString(coord.getY()) + ",0.0");
            placemark.setAbstractGeometryGroup(this.kmlObjectFactory.createPoint(point));
            if (gehValue < 5.0) {
                placemark.setStyleUrl(this.greenCircleStyle.getId());
            } else if (gehValue < 10.0) {
                placemark.setStyleUrl(this.yellowCircleStyle.getId());
            } else if (gehValue > 10.0) {
                placemark.setStyleUrl(this.redCircleStyle.getId());
            } else {
                placemark.setStyleUrl(this.greyCircleStyle.getId());
            }
            folderGEH.getAbstractFeatureGroup().add(this.kmlObjectFactory.createPlacemark(placemark));
        }
    }

    private Coord calculatePlacemarkPosition(Link l) {
        Coord coordFrom = l.getFromNode().getCoord();
        Coord coordTo = l.getToNode().getCoord();
        double xDiff = coordTo.getX() - coordFrom.getX();
        double yDiff = coordTo.getY() - coordFrom.getY();
        double length = Math.sqrt(xDiff * xDiff + yDiff * yDiff);
        double scale = 0.4;
        scale = l.getLength() * scale;
        Coord vec = new Coord(coordFrom.getX() + xDiff * scale / length, coordFrom.getY() + yDiff * scale / length);
        return vec;
    }

    private String createPlacemarkDescription(String linkid, CountSimComparison csc, double relativeError, double normalizedRelativeError, double gehValue, int timestep, String imagePath) {
        StringBuilder buffer = new StringBuilder(100);
        if (csc.getCsId() != null) {
            buffer.append("<h2>");
            buffer.append(CSID);
            buffer.append(csc.getCsId());
            buffer.append("</h2>");
        }
        buffer.append("<h2>");
        buffer.append(LINK);
        buffer.append(linkid);
        buffer.append("</h2>");
        buffer.append("<h3>");
        buffer.append(H24OVERVIEW);
        buffer.append("</h3>");
        buffer.append("<p>");
        buffer.append(IMG);
        buffer.append(imagePath);
        buffer.append(IMGEND);
        buffer.append("</p>");
        buffer.append("<h3>");
        buffer.append(DETAILSFROM);
        buffer.append(this.timestepToString(timestep - 1));
        buffer.append(OCLOCKTO);
        buffer.append(this.timestepToString(timestep));
        buffer.append(OCLOCK);
        buffer.append("</h3>");
        buffer.append("<p>");
        buffer.append(COUNTVALUE);
        buffer.append(csc.getCountValue());
        buffer.append("</p>");
        buffer.append("<p>");
        buffer.append(MATSIMVALUE);
        buffer.append(csc.getSimulationValue());
        buffer.append("</p>");
        buffer.append("<p>");
        buffer.append(RELERROR);
        buffer.append(nf.format(relativeError * 100.0) + "%");
        buffer.append("</p>");
        buffer.append("<p>");
        buffer.append(NORMRELERROR);
        buffer.append(nf.format(normalizedRelativeError * 100.0) + "%");
        buffer.append("</p>");
        buffer.append("<p>");
        buffer.append(GEH);
        buffer.append(gehValue);
        buffer.append("</p>");
        return buffer.toString();
    }

    private String timestepToString(int timestep) {
        if (timestep < 10) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(ZERO);
            buffer.append(Integer.toString(timestep));
            return buffer.toString();
        }
        return Integer.toString(timestep);
    }

    private void addCountsSimRealPerHourGraphs(FolderType folder, int timestep, TimeSpanType timespan) {
        try {
            StringBuffer filename = new StringBuffer(this.graphname);
            filename.append(Integer.toString(timestep));
            filename.append(PNG);
            CountsSimRealPerHourGraph graph = new CountsSimRealPerHourGraph(this.countComparisonFilter.getCountsForHour(null), this.iterationNumber, filename.toString());
            graph.createChart(timestep);
            this.writeChartToKmz(filename.toString(), graph.getChart());
            ScreenOverlayType overlay = this.kmlObjectFactory.createScreenOverlayType();
            LinkType icon = this.kmlObjectFactory.createLinkType();
            icon.setHref("./" + filename.toString());
            overlay.setIcon(icon);
            overlay.setName(graph.getChartTitle());
            Vec2Type overlayXY = this.kmlObjectFactory.createVec2Type();
            overlayXY.setX(1.0);
            overlayXY.setY(1.0);
            overlayXY.setXunits(UnitsEnumType.FRACTION);
            overlayXY.setYunits(UnitsEnumType.FRACTION);
            overlay.setOverlayXY(overlayXY);
            Vec2Type screenXY = this.kmlObjectFactory.createVec2Type();
            screenXY.setX(0.98);
            screenXY.setY(0.98);
            screenXY.setXunits(UnitsEnumType.FRACTION);
            screenXY.setYunits(UnitsEnumType.FRACTION);
            overlay.setScreenXY(screenXY);
            overlay.setAbstractTimePrimitiveGroup(this.kmlObjectFactory.createTimeSpan(timespan));
            folder.getAbstractFeatureGroup().add(this.kmlObjectFactory.createScreenOverlay(overlay));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createCountsLoadCurveGraphs() {
        CountsLoadCurveGraphCreator cgc = new CountsLoadCurveGraphCreator("");
        List<CountsGraph> graphs = cgc.createGraphs(this.countComparisonFilter.getCountsForHour(null), this.iterationNumber);
        this.countsLoadCurveGraphMap = new HashMap<String, String>(graphs.size());
        for (CountsGraph cg : graphs) {
            try {
                StringBuffer filename = new StringBuffer();
                String linkid = ((CountsLoadCurveGraph)cg).getLinkId();
                filename.append(linkid);
                filename.append(PNG);
                this.writeChartToKmz(filename.toString(), cg.getChart());
                this.countsLoadCurveGraphMap.put(linkid, filename.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void createCountsGEHCurveGraphs() {
        CountsGEHCurveGraphCreator cgc = new CountsGEHCurveGraphCreator("");
        List<CountsGraph> graphs = cgc.createGraphs(this.countComparisonFilter.getCountsForHour(null), this.iterationNumber);
        this.countsGEHCurveGraphMap = new HashMap<String, String>(graphs.size());
        for (CountsGraph cg : graphs) {
            try {
                StringBuffer filename = new StringBuffer();
                String linkId = ((CountsGEHCurveGraph)cg).getLinkId();
                filename.append(linkId);
                filename.append("_GEH");
                filename.append(PNG);
                this.writeChartToKmz(filename.toString(), cg.getChart());
                this.countsGEHCurveGraphMap.put(linkId, filename.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void writeChartToKmz(String filename, JFreeChart chart) throws IOException {
        byte[] img = ChartUtils.encodeAsPNG(chart.createBufferedImage(400, 300));
        this.writer.addNonKMLFile(img, filename);
    }

    private ScreenOverlayType createBoxPlotErrorGraph() {
        BoxPlotErrorGraph ep;
        try {
            ep = new BoxPlotErrorGraph(this.countComparisonFilter.getCountsForHour(null), this.iterationNumber, null, "error graph");
            ((CountsGraph)ep).createChart(0);
        }
        catch (IllegalArgumentException e) {
            log.error("Could not create BoxPlot-ErrorGraph.", e);
            return null;
        }
        String filename = "errorGraphBoxPlot.png";
        try {
            this.writeChartToKmz(filename, ep.getChart());
            return this.createOverlayBottomRight(filename, "Error Graph [Box-Plot]");
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private ScreenOverlayType createBoxPlotNormalizedErrorGraph() {
        BoxPlotNormalizedErrorGraph ep;
        try {
            ep = new BoxPlotNormalizedErrorGraph(this.countComparisonFilter.getCountsForHour(null), this.iterationNumber, null, "error graph");
            ((CountsGraph)ep).createChart(0);
        }
        catch (IllegalArgumentException e) {
            log.error("Could not create BoxPlot-NormalizedErrorGraph.", e);
            return null;
        }
        String filename = "errorGraphNormalizedBoxPlot.png";
        try {
            this.writeChartToKmz(filename, ep.getChart());
            return this.createOverlayBottomRight(filename, "Normalized Error Graph [Box-Plot]");
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private ScreenOverlayType createBiasErrorGraph(String kmlFilename) {
        BiasErrorGraph ep = new BiasErrorGraph(this.countComparisonFilter.getCountsForHour(null), this.iterationNumber, null, "error graph");
        ep.createChart(0);
        double[] meanError = ep.getMeanRelError();
        double[] meanBias = ep.getMeanBias();
        int index = kmlFilename.lastIndexOf(System.getProperty("file.separator"));
        if (index == -1) {
            index = kmlFilename.lastIndexOf(47);
        }
        String outdir = index == -1 ? "" : kmlFilename.substring(0, index) + System.getProperty("file.separator");
        String file = outdir + "biasErrorGraphData.txt";
        log.info("writing chart data to " + new File(file).getAbsolutePath());
        try {
            BufferedWriter bwriter = IOUtils.getBufferedWriter(file);
            StringBuilder buffer = new StringBuilder(200);
            buffer.append("hour \t mean relative error \t mean bias");
            bwriter.write(buffer.toString());
            bwriter.newLine();
            for (int i = 0; i < meanError.length; ++i) {
                buffer.delete(0, buffer.length());
                buffer.append(i + 1);
                buffer.append('\t');
                buffer.append(meanError[i]);
                buffer.append('\t');
                buffer.append(meanBias[i]);
                bwriter.write(buffer.toString());
                bwriter.newLine();
            }
            bwriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String filename = "errorGraphErrorBias.png";
        try {
            this.writeChartToKmz(filename, ep.getChart());
            return this.createOverlayBottomRight(filename, "Error Graph [Error/Bias]");
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private ScreenOverlayType createBiasNormalizedErrorGraph(String kmlFilename) {
        BiasNormalizedErrorGraph ep = new BiasNormalizedErrorGraph(this.countComparisonFilter.getCountsForHour(null), this.iterationNumber, null, "error graph");
        ep.createChart(0);
        double[] meanError = ep.getMeanNormRelError();
        double[] meanBias = ep.getMeanBias();
        int index = kmlFilename.lastIndexOf(System.getProperty("file.separator"));
        if (index == -1) {
            index = kmlFilename.lastIndexOf(47);
        }
        String outdir = index == -1 ? "" : kmlFilename.substring(0, index) + System.getProperty("file.separator");
        String file = outdir + "biasNormalizedErrorGraphData.txt";
        log.info("writing chart data to " + new File(file).getAbsolutePath());
        try {
            BufferedWriter bwriter = IOUtils.getBufferedWriter(file);
            StringBuilder buffer = new StringBuilder(200);
            buffer.append("hour \t mean normalized relative error \t mean bias");
            bwriter.write(buffer.toString());
            bwriter.newLine();
            for (int i = 0; i < meanError.length; ++i) {
                buffer.delete(0, buffer.length());
                buffer.append(i + 1);
                buffer.append('\t');
                buffer.append(meanError[i]);
                buffer.append('\t');
                buffer.append(meanBias[i]);
                bwriter.write(buffer.toString());
                bwriter.newLine();
            }
            bwriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String filename = "errorGraphNormalizedErrorBias.png";
        try {
            this.writeChartToKmz(filename, ep.getChart());
            return this.createOverlayBottomRight(filename, "Normalized Error Graph [Error/Bias]");
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private ScreenOverlayType createAWTVGraph() {
        CountsSimReal24Graph awtv = new CountsSimReal24Graph(this.countComparisonFilter.getCountsForHour(null), this.iterationNumber, "awtv graph");
        ((CountsGraph)awtv).createChart(0);
        String filename = "awtv.png";
        try {
            this.writeChartToKmz(filename, awtv.getChart());
            return this.createOverlayBottomRight("./" + filename, "AWTV");
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private ScreenOverlayType createOverlayBottomRight(String fileName, String overlayName) {
        ScreenOverlayType overlay = this.kmlObjectFactory.createScreenOverlayType();
        LinkType icon1 = this.kmlObjectFactory.createLinkType();
        icon1.setHref("./" + fileName);
        overlay.setIcon(icon1);
        overlay.setName(overlayName);
        Vec2Type overlayXY = this.kmlObjectFactory.createVec2Type();
        overlayXY.setX(1.0);
        overlayXY.setY(0.0);
        overlayXY.setXunits(UnitsEnumType.FRACTION);
        overlayXY.setYunits(UnitsEnumType.FRACTION);
        overlay.setOverlayXY(overlayXY);
        Vec2Type screenXY = this.kmlObjectFactory.createVec2Type();
        screenXY.setX(0.98);
        screenXY.setY(0.1);
        screenXY.setXunits(UnitsEnumType.FRACTION);
        screenXY.setYunits(UnitsEnumType.FRACTION);
        overlay.setScreenXY(screenXY);
        return overlay;
    }

    private void finish() {
        this.writer.writeMainKml(this.mainKml);
        this.writer.close();
        log.info("DONE with writing kml file.");
    }
}

