/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.counts.algorithms;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.counts.CountSimComparison;

public class CountSimComparisonLinkFilter {
    private Hashtable<Id<Link>, List<CountSimComparison>> countSimComparisonLinkMap;
    private final List<CountSimComparison> countSimComparisons;

    public CountSimComparisonLinkFilter(List<CountSimComparison> countSimComparisons) {
        this.countSimComparisons = countSimComparisons;
        this.countSimComparisonLinkMap = new Hashtable();
        if (this.countSimComparisons.size() < 1) {
            return;
        }
        Vector<CountSimComparison> countSimComparisonsPerLink = new Vector<CountSimComparison>();
        Id prevId = this.countSimComparisons.get(0).getId();
        Iterator<CountSimComparison> csc_it = this.countSimComparisons.iterator();
        while (csc_it.hasNext()) {
            CountSimComparison csc = csc_it.next();
            if (csc.getId().compareTo(prevId) == 0) {
                countSimComparisonsPerLink.add(csc);
            }
            if (csc.getId().compareTo(prevId) != 0 || !csc_it.hasNext()) {
                this.countSimComparisonLinkMap.put(prevId, countSimComparisonsPerLink);
                countSimComparisonsPerLink = new Vector();
                countSimComparisonsPerLink.add(csc);
            }
            prevId = csc.getId();
        }
    }

    public List<CountSimComparison> getCountsForLink(Id<Link> linkfilter) {
        if (linkfilter == null) {
            return this.countSimComparisons;
        }
        return this.countSimComparisonLinkMap.get(linkfilter);
    }

    public double getAggregatedCountValue(Id<Link> linkfilter) {
        Iterator<CountSimComparison> csc_it = this.countSimComparisonLinkMap.get(linkfilter).iterator();
        double countValue = 0.0;
        while (csc_it.hasNext()) {
            CountSimComparison csc = csc_it.next();
            countValue += csc.getCountValue();
        }
        return countValue;
    }

    public double getAggregatedSimValue(Id<Link> linkfilter) {
        Iterator<CountSimComparison> csc_it = this.countSimComparisonLinkMap.get(linkfilter).iterator();
        double simValue = 0.0;
        while (csc_it.hasNext()) {
            CountSimComparison csc = csc_it.next();
            simValue += csc.getSimulationValue();
        }
        return simValue;
    }

    public Vector<Id<Link>> getLinkIds() {
        Vector<Id<Link>> linkIds = new Vector<Id<Link>>(this.countSimComparisonLinkMap.keySet());
        Collections.sort(linkIds);
        return linkIds;
    }
}

