/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.counts.algorithms;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.matsim.counts.CountSimComparison;
import org.matsim.counts.algorithms.CountSimComparisonLinkFilter;
import org.matsim.counts.algorithms.CountSimComparisonWriter;

public class CountSimComparisonTableWriter
extends CountSimComparisonWriter {
    private static final String SEPARATOR = "\t";
    private static final String NEWLINE = "\n";
    private static final String[] COLUMNHEADERS = new String[]{"Link Id", "Count Station Id", "Hour", "MATSIM volumes", "Count volumes", "Relative Error", "Normalized Relative Error", "GEH"};
    private final NumberFormat numberFormat;
    private static final Logger log = Logger.getLogger(CountSimComparisonTableWriter.class);

    public CountSimComparisonTableWriter(List<CountSimComparison> countSimComparisons, Locale l) {
        super(countSimComparisons);
        this.numberFormat = l == null ? new DecimalFormat("#.############") : NumberFormat.getInstance(l);
        this.numberFormat.setGroupingUsed(false);
    }

    @Override
    public void writeFile(String filename) {
        log.info("Writing CountsSimComparison to " + filename);
        try (BufferedWriter out = new BufferedWriter(new FileWriter(filename));){
            out.write(COLUMNHEADERS[0]);
            for (int i = 1; i < COLUMNHEADERS.length; ++i) {
                out.write(SEPARATOR);
                out.write(COLUMNHEADERS[i]);
            }
            out.write(NEWLINE);
            for (CountSimComparison csc : this.countComparisonFilter.getCountsForHour(null)) {
                out.write(csc.getId().toString());
                out.write(SEPARATOR);
                out.write(csc.getCsId());
                out.write(SEPARATOR);
                out.write(Integer.toString(csc.getHour()));
                out.write(SEPARATOR);
                out.write(this.numberFormat.format(csc.getSimulationValue()));
                out.write(SEPARATOR);
                out.write(this.numberFormat.format(csc.getCountValue()));
                out.write(SEPARATOR);
                out.write(this.numberFormat.format(csc.calculateRelativeError()));
                out.write(SEPARATOR);
                out.write(this.numberFormat.format(csc.calculateNormalizedRelativeError()));
                out.write(SEPARATOR);
                out.write(this.numberFormat.format(csc.calculateGEHValue()));
                out.write(NEWLINE);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.writeAWTVTable(filename);
    }

    private void writeAWTVTable(String file) {
        String filename = file.substring(0, file.length() - 4) + "AWTV.txt";
        log.info("Writing 'average weekday traffic volume' to " + filename);
        CountSimComparisonLinkFilter linkFilter = new CountSimComparisonLinkFilter(this.countComparisonFilter.getCountsForHour(null));
        try (BufferedWriter out = new BufferedWriter(new FileWriter(filename));){
            out.write("Link Id");
            out.write(SEPARATOR);
            out.write("Count Station Id");
            out.write(SEPARATOR);
            out.write("MATSIM volumes");
            out.write(SEPARATOR);
            out.write("Count volumes");
            out.write(SEPARATOR);
            out.write("Normalized Relative Error");
            out.write(NEWLINE);
            for (CountSimComparison csc : this.countComparisonFilter.getCountsForHour(null)) {
                double countValue;
                double simValue = linkFilter.getAggregatedSimValue(csc.getId());
                double max = Math.max(simValue, countValue = linkFilter.getAggregatedCountValue(csc.getId()));
                double nomRelError = max == 0.0 ? 0.0 : Math.abs(simValue - countValue) / max;
                out.write(csc.getId().toString());
                out.write(SEPARATOR);
                out.write(csc.getCsId());
                out.write(SEPARATOR);
                out.write(this.numberFormat.format(simValue));
                out.write(SEPARATOR);
                out.write(this.numberFormat.format(countValue));
                out.write(SEPARATOR);
                out.write(this.numberFormat.format(nomRelError));
                out.write(NEWLINE);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

