/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.counts.algorithms;

import java.util.List;
import java.util.Vector;
import org.matsim.counts.CountSimComparison;

public class CountSimComparisonTimeFilter {
    private final List<CountSimComparison>[] countSimComparisonTimeMap;
    private final List<CountSimComparison> countSimComparisons;

    public CountSimComparisonTimeFilter(List<CountSimComparison> countSimComparisons) {
        this.countSimComparisons = countSimComparisons;
        int countsPerHour = this.countSimComparisons.size() / 24;
        this.countSimComparisonTimeMap = new List[24];
        for (int i = 0; i < 24; ++i) {
            this.countSimComparisonTimeMap[i] = new Vector<CountSimComparison>(countsPerHour);
        }
        for (CountSimComparison csc : this.countSimComparisons) {
            this.countSimComparisonTimeMap[csc.getHour() - 1].add(csc);
        }
    }

    public List<CountSimComparison> getCountsForHour(Integer timefilter) {
        if (timefilter == null) {
            return this.countSimComparisons;
        }
        return this.countSimComparisonTimeMap[timefilter - 1];
    }
}

