/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.counts.algorithms;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.matsim.analysis.VolumesAnalyzer;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.utils.geometry.CoordUtils;
import org.matsim.counts.Count;
import org.matsim.counts.CountSimComparison;
import org.matsim.counts.CountSimComparisonImpl;
import org.matsim.counts.Counts;
import org.matsim.counts.Volume;
import org.matsim.pt.transitSchedule.api.TransitStopFacility;

public class CountsComparisonAlgorithm {
    private final VolumesForId volumesPerLinkPerHour;
    private final Counts<Link> counts;
    private final List<CountSimComparison> result;
    private DistanceFilter distanceFilter = new DistanceFilter(){

        @Override
        public boolean isInRange(Count<Link> count) {
            return true;
        }
    };
    private final Network network;
    private double countsScaleFactor;
    private static final Logger log = Logger.getLogger(CountsComparisonAlgorithm.class);

    public CountsComparisonAlgorithm(final VolumesAnalyzer volumes, Counts<Link> counts, Network network, double countsScaleFactor) {
        this.counts = counts;
        this.result = new ArrayList<CountSimComparison>();
        this.network = network;
        this.countsScaleFactor = countsScaleFactor;
        this.volumesPerLinkPerHour = new VolumesForId(){

            @Override
            public double[] getVolumesForStop(Id<TransitStopFacility> locationId) {
                return volumes.getVolumesPerHourForLink(Id.create(locationId, Link.class));
            }
        };
    }

    public CountsComparisonAlgorithm(final Map<Id<Link>, double[]> volumesPerLinkPerHour, Counts<Link> counts, Network network, double countsScaleFactor) {
        this.volumesPerLinkPerHour = new VolumesForId(){

            @Override
            public double[] getVolumesForStop(Id<TransitStopFacility> locationId) {
                return (double[])volumesPerLinkPerHour.get(Id.create(locationId, Link.class));
            }
        };
        this.counts = counts;
        this.result = new ArrayList<CountSimComparison>();
        this.network = network;
        this.countsScaleFactor = countsScaleFactor;
    }

    public CountsComparisonAlgorithm(VolumesForId volumesPerLinkPerHour, Counts<Link> counts, Network network, double countsScaleFactor) {
        this.volumesPerLinkPerHour = volumesPerLinkPerHour;
        this.counts = counts;
        this.result = new ArrayList<CountSimComparison>();
        this.network = network;
        this.countsScaleFactor = countsScaleFactor;
    }

    private void compare() {
        for (Count<Link> count : this.counts.getCounts().values()) {
            if (!this.distanceFilter.isInRange(count)) continue;
            double[] volumes = this.volumesPerLinkPerHour.getVolumesForStop(Id.create(count.getId(), TransitStopFacility.class));
            if (volumes == null || volumes.length == 0) {
                log.warn("No volumes for count location: " + count.getId().toString());
                continue;
            }
            for (int hour = 1; hour <= 24; ++hour) {
                Volume volume = count.getVolume(hour);
                if (volume == null) continue;
                double countValue = volume.getValue();
                double simValue = volumes[hour - 1];
                this.result.add(new CountSimComparisonImpl(count.getId(), count.getCsLabel(), hour, countValue, simValue *= this.countsScaleFactor));
            }
        }
    }

    public List<CountSimComparison> getComparison() {
        return this.result;
    }

    public void run() {
        this.compare();
    }

    public void setDistanceFilter(final Double distance, String nodeId) {
        final Coord centerCoord = this.network.getNodes().get(Id.create(nodeId, Node.class)).getCoord();
        this.distanceFilter = new DistanceFilter(){

            @Override
            public boolean isInRange(Count<Link> count) {
                Link l = CountsComparisonAlgorithm.this.network.getLinks().get(count.getId());
                if (l == null) {
                    log.warn("Cannot find requested link: " + count.getId().toString());
                    return false;
                }
                double dist = CoordUtils.calcEuclideanDistance(l.getCoord(), centerCoord);
                return dist < distance;
            }
        };
    }

    public void setCountCoordUsingDistanceFilter(final Double distance, String nodeId) {
        final Coord centerCoord = this.network.getNodes().get(Id.create(nodeId, Node.class)).getCoord();
        this.distanceFilter = new DistanceFilter(){

            @Override
            public boolean isInRange(Count<Link> count) {
                double dist = CoordUtils.calcEuclideanDistance(count.getCoord(), centerCoord);
                return dist < distance;
            }
        };
    }

    public void setDistanceFilter(DistanceFilter distanceFilter) {
        this.distanceFilter = distanceFilter;
    }

    public void setCountsScaleFactor(double countsScaleFactor) {
        this.countsScaleFactor = countsScaleFactor;
    }

    public static interface DistanceFilter {
        public boolean isInRange(Count<Link> var1);
    }

    public static interface VolumesForId {
        public double[] getVolumesForStop(Id<TransitStopFacility> var1);
    }
}

