/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.counts.algorithms;

import java.io.File;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.matsim.counts.CountSimComparison;
import org.matsim.counts.algorithms.graphs.CountsGraph;
import org.matsim.counts.algorithms.graphs.CountsGraphsCreator;
import org.matsim.counts.algorithms.graphs.helper.OutputDelegate;

public class CountsHtmlAndGraphsWriter {
    private String iterationPath;
    private List<CountSimComparison> countSimComparisons;
    private int iteration;
    private OutputDelegate outputDelegate;
    private List<CountsGraphsCreator> graphsCreators;
    private static final Logger log = Logger.getLogger(CountsHtmlAndGraphsWriter.class);

    public CountsHtmlAndGraphsWriter(String iterationPath, List<CountSimComparison> countSimComparisons, int iteration) {
        this.iterationPath = iterationPath + "/graphs/";
        this.countSimComparisons = countSimComparisons;
        this.iteration = iteration;
        this.outputDelegate = new OutputDelegate(this.iterationPath);
        new File(this.iterationPath).mkdir();
        this.graphsCreators = new Vector<CountsGraphsCreator>();
    }

    public OutputDelegate getOutput() {
        return this.outputDelegate;
    }

    public void addGraphsCreator(CountsGraphsCreator graphsCreator) {
        this.graphsCreators.add(graphsCreator);
    }

    public void createHtmlAndGraphs() {
        log.info("Creating graphs");
        for (CountsGraphsCreator cgc : this.graphsCreators) {
            List<CountsGraph> graphs = cgc.createGraphs(this.countSimComparisons, this.iteration);
            this.outputDelegate.addSection(cgc.getSection());
            for (CountsGraph cg : graphs) {
                this.outputDelegate.addCountsGraph(cg);
            }
        }
        this.outputDelegate.outputHtml();
    }
}

