/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.counts.algorithms.graphs;

import java.awt.Font;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.DefaultCategoryDataset;
import org.matsim.counts.ComparisonErrorStatsCalculator;
import org.matsim.counts.CountSimComparison;
import org.matsim.counts.algorithms.graphs.CountsGraph;

public final class BiasNormalizedErrorGraph
extends CountsGraph {
    private ComparisonErrorStatsCalculator errorStats;

    public BiasNormalizedErrorGraph(List<CountSimComparison> ccl, int iteration, String filename, String chartTitle) {
        super(ccl, iteration, filename, chartTitle);
    }

    @Override
    public JFreeChart createChart(int nbr) {
        DefaultCategoryDataset dataset0 = new DefaultCategoryDataset();
        DefaultCategoryDataset dataset1 = new DefaultCategoryDataset();
        this.errorStats = new ComparisonErrorStatsCalculator(this.ccl_);
        double[] meanNormRelError = this.errorStats.getMeanNormRelError();
        double[] meanBias = this.errorStats.getMeanBias();
        for (int h2 = 0; h2 < 24; ++h2) {
            int n = h2;
            meanNormRelError[n] = meanNormRelError[n] * 100.0;
            dataset0.addValue(meanNormRelError[h2], (Comparable)((Object)"Mean norm rel error"), (Comparable)((Object)Integer.toString(h2 + 1)));
            dataset1.addValue(meanBias[h2], (Comparable)((Object)"Mean bias"), (Comparable)((Object)Integer.toString(h2 + 1)));
        }
        this.chart_ = ChartFactory.createLineChart("", "Hour", "Mean norm rel error [%]", dataset0, PlotOrientation.VERTICAL, true, true, false);
        CategoryPlot plot = this.chart_.getCategoryPlot();
        plot.setDomainAxisLocation(AxisLocation.BOTTOM_OR_RIGHT);
        plot.setDataset(1, dataset1);
        plot.mapDatasetToRangeAxis(1, 1);
        LineAndShapeRenderer renderer = new LineAndShapeRenderer();
        renderer.setSeriesToolTipGenerator(0, new StandardCategoryToolTipGenerator());
        plot.setRenderer(0, renderer);
        CategoryAxis axis1 = new CategoryAxis("Hour");
        axis1.setTickLabelFont(new Font("SansSerif", 0, 7));
        plot.setDomainAxis(axis1);
        NumberAxis axis2 = new NumberAxis("Mean bias [veh/h]");
        plot.setRangeAxis(1, axis2);
        ValueAxis axis3 = plot.getRangeAxis(0);
        axis3.setRange(0.0, 100.0);
        LineAndShapeRenderer renderer2 = new LineAndShapeRenderer();
        renderer2.setSeriesToolTipGenerator(0, new StandardCategoryToolTipGenerator());
        renderer2.setSeriesToolTipGenerator(1, new StandardCategoryToolTipGenerator());
        plot.setRenderer(1, renderer2);
        plot.setDatasetRenderingOrder(DatasetRenderingOrder.REVERSE);
        return this.chart_;
    }

    public double[] getMeanNormRelError() {
        if (this.errorStats == null) {
            throw new RuntimeException("Object not initialized correctly. Call createChart(..) first!");
        }
        return this.errorStats.getMeanRelError();
    }

    public double[] getMeanBias() {
        if (this.errorStats == null) {
            throw new RuntimeException("Object not initialized correctly. Call createChart(..) first!");
        }
        return this.errorStats.getMeanBias();
    }
}

