/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.counts.algorithms.graphs;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.BoxAndWhiskerToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.CombinedDomainCategoryPlot;
import org.jfree.chart.renderer.category.BoxAndWhiskerRenderer;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;
import org.matsim.counts.CountSimComparison;
import org.matsim.counts.algorithms.graphs.CountsGraph;

public final class BoxPlotNormalizedErrorGraph
extends CountsGraph {
    public BoxPlotNormalizedErrorGraph(List<CountSimComparison> ccl, int iteration, String filename, String chartTitle) {
        super(ccl, iteration, filename, chartTitle);
    }

    @Override
    public JFreeChart createChart(int nbr) {
        DefaultBoxAndWhiskerCategoryDataset dataset0 = new DefaultBoxAndWhiskerCategoryDataset();
        DefaultBoxAndWhiskerCategoryDataset dataset1 = new DefaultBoxAndWhiskerCategoryDataset();
        ArrayList[] listRel = new ArrayList[24];
        ArrayList[] listAbs = new ArrayList[24];
        for (int i = 0; i < 24; ++i) {
            listRel[i] = new ArrayList();
            listAbs[i] = new ArrayList();
        }
        for (CountSimComparison cc : this.ccl_) {
            int hour = cc.getHour() - 1;
            listRel[hour].add(cc.calculateNormalizedRelativeError() * 100.0);
            listAbs[hour].add(cc.getSimulationValue() - cc.getCountValue());
        }
        for (int i = 0; i < 24; ++i) {
            dataset0.add(listRel[i], (Comparable)((Object)"Rel Norm Error"), (Comparable)((Object)Integer.toString(i + 1)));
            dataset1.add(listAbs[i], (Comparable)((Object)"Abs Error"), (Comparable)((Object)Integer.toString(i + 1)));
        }
        String title = "Iteration: " + this.iteration_;
        CombinedDomainCategoryPlot plot = new CombinedDomainCategoryPlot();
        CategoryAxis xAxis = new CategoryAxis("Hour");
        NumberAxis yAxis0 = new NumberAxis("Norm. Rel. Error [%]");
        NumberAxis yAxis1 = new NumberAxis("Signed Abs. Error [veh]");
        yAxis0.setAutoRangeIncludesZero(false);
        yAxis1.setAutoRangeIncludesZero(false);
        BoxAndWhiskerRenderer renderer = new BoxAndWhiskerRenderer();
        renderer.setFillBox(false);
        renderer.setSeriesPaint(0, Color.blue);
        renderer.setSeriesToolTipGenerator(0, new BoxAndWhiskerToolTipGenerator());
        CategoryPlot subplot0 = new CategoryPlot(dataset0, xAxis, yAxis0, renderer);
        CategoryPlot subplot1 = new CategoryPlot(dataset1, xAxis, yAxis1, renderer);
        plot.add(subplot0);
        plot.add(subplot1);
        CategoryAxis axis1 = new CategoryAxis("hour");
        axis1.setTickLabelFont(new Font("SansSerif", 0, 7));
        axis1.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        plot.setDomainAxis(axis1);
        this.chart_ = new JFreeChart(title, new Font("SansSerif", 1, 14), plot, false);
        return this.chart_;
    }
}

