/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.counts.algorithms.graphs;

import java.awt.Color;
import java.awt.Paint;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.data.category.DefaultCategoryDataset;
import org.matsim.counts.CountSimComparison;
import org.matsim.counts.algorithms.graphs.CountsGraph;

public final class CountsGEHCurveGraph
extends CountsGraph {
    private final DefaultCategoryDataset dataset = new DefaultCategoryDataset();
    private String linkId;

    public CountsGEHCurveGraph(List<CountSimComparison> ccl, int iteration, String filename) {
        super(ccl, iteration, filename, filename);
    }

    public void clearDatasets() {
        this.dataset.clear();
    }

    public void add2LoadCurveDataSets(CountSimComparison cc) {
        String h2 = Integer.toString(cc.getHour());
        this.dataset.addValue(cc.calculateGEHValue(), (Comparable)((Object)"GEH"), (Comparable)((Object)h2));
    }

    @Override
    public JFreeChart createChart(int nbr) {
        String title = this.getChartTitle() + ", Iteration: " + this.iteration_;
        this.chart_ = ChartFactory.createBarChart(title, "Hour", "GEH", this.dataset, PlotOrientation.VERTICAL, false, false, false);
        CategoryPlot plot = this.chart_.getCategoryPlot();
        plot.getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        BarRenderer renderer = new BarRenderer(){

            @Override
            public Paint getItemPaint(int row, int column) {
                double value = CountsGEHCurveGraph.this.dataset.getValue(row, column).doubleValue();
                if (value <= 5.0) {
                    return Color.green;
                }
                if (value >= 10.0) {
                    return Color.red;
                }
                if (value < 7.5) {
                    int mixed = CountsGEHCurveGraph.mix(Color.yellow.getRGB(), Color.green.getRGB(), (7.5 - value) / 2.5);
                    return new Color(mixed);
                }
                int mixed = CountsGEHCurveGraph.mix(Color.red.getRGB(), Color.yellow.getRGB(), (10.0 - value) / 2.5);
                return new Color(mixed);
            }
        };
        renderer.setSeriesOutlinePaint(0, Color.black);
        renderer.setSeriesPaint(0, Color.getHSBColor(0.62f, 0.56f, 0.93f));
        renderer.setSeriesToolTipGenerator(0, new StandardCategoryToolTipGenerator());
        renderer.setItemMargin(0.0);
        renderer.setShadowVisible(false);
        renderer.setBarPainter(new StandardBarPainter());
        this.chart_.setBackgroundPaint(Color.getHSBColor(0.0f, 0.0f, 0.93f));
        plot.setBackgroundPaint(Color.white);
        plot.setRangeGridlinePaint(Color.gray);
        plot.setRangeGridlinesVisible(true);
        plot.setRenderer(0, renderer);
        plot.setDomainAxisLocation(AxisLocation.BOTTOM_OR_RIGHT);
        plot.mapDatasetToRangeAxis(1, 1);
        CategoryAxis axis1 = plot.getDomainAxis();
        axis1.setCategoryMargin(0.25);
        return this.chart_;
    }

    public String getLinkId() {
        return this.linkId;
    }

    public void setLinkId(String linkId) {
        this.linkId = linkId;
    }

    private static int mix(int argb1, int argb2, double percentage) {
        int a1 = argb1 >> 24 & 0xFF;
        int r1 = argb1 >> 16 & 0xFF;
        int g1 = argb1 >> 8 & 0xFF;
        int b1 = argb1 & 0xFF;
        int a2 = argb2 >> 24 & 0xFF;
        int r2 = argb2 >> 16 & 0xFF;
        int g2 = argb2 >> 8 & 0xFF;
        int b2 = argb2 & 0xFF;
        double p = percentage;
        int a3 = (int)((double)a1 + p * (double)(a2 - a1));
        int r3 = (int)((double)r1 + p * (double)(r2 - r1));
        int g3 = (int)((double)g1 + p * (double)(g2 - g1));
        int b3 = (int)((double)b1 + p * (double)(b2 - b1));
        return a3 << 24 | r3 << 16 | g3 << 8 | b3;
    }
}

