/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.counts.algorithms.graphs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.matsim.api.core.v01.Id;
import org.matsim.counts.CountSimComparison;
import org.matsim.counts.algorithms.graphs.CountsGEHCurveGraph;
import org.matsim.counts.algorithms.graphs.CountsGraph;
import org.matsim.counts.algorithms.graphs.CountsGraphsCreator;
import org.matsim.counts.algorithms.graphs.helper.MyURL;

public class CountsGEHCurveGraphCreator
extends CountsGraphsCreator {
    public CountsGEHCurveGraphCreator(String sectionTitle) {
        super(sectionTitle);
    }

    @Override
    public List<CountsGraph> createGraphs(List<CountSimComparison> ccl, int iteration) {
        ArrayList<CountsGraph> graphList = new ArrayList<CountsGraph>();
        Iterator<CountSimComparison> l_it = ccl.iterator();
        CountSimComparison cc_last = null;
        while (l_it.hasNext()) {
            CountsGEHCurveGraph lcg = new CountsGEHCurveGraph(ccl, iteration, "dummy");
            if (cc_last != null) {
                lcg.add2LoadCurveDataSets(cc_last);
            }
            CountSimComparison cc = l_it.next();
            Id linkId = cc.getId();
            while (cc.getId().equals(linkId)) {
                if (l_it.hasNext()) {
                    lcg.add2LoadCurveDataSets(cc);
                    cc = l_it.next();
                    continue;
                }
                lcg.add2LoadCurveDataSets(cc);
                break;
            }
            lcg.setChartTitle("Link " + linkId);
            lcg.setFilename("link" + linkId);
            lcg.setLinkId(linkId.toString());
            lcg.createChart(0);
            graphList.add(lcg);
            this.section.addURL(new MyURL("link" + linkId + ".html", "link" + linkId));
            cc_last = cc;
        }
        return graphList;
    }
}

