/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.counts.algorithms.graphs;

import java.awt.Color;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.data.category.DefaultCategoryDataset;
import org.matsim.counts.CountSimComparison;
import org.matsim.counts.algorithms.graphs.CountsGraph;

public final class CountsLoadCurveGraph
extends CountsGraph {
    private final DefaultCategoryDataset dataset0 = new DefaultCategoryDataset();
    private String linkId;

    public CountsLoadCurveGraph(List<CountSimComparison> ccl, int iteration, String filename) {
        super(ccl, iteration, filename, filename);
    }

    public void clearDatasets() {
        this.dataset0.clear();
    }

    public void add2LoadCurveDataSets(CountSimComparison cc) {
        String matsim_series = "Sim Volumes";
        String real_series = "Count Volumes";
        String h2 = Integer.toString(cc.getHour());
        this.dataset0.addValue(cc.getSimulationValue(), (Comparable)((Object)matsim_series), (Comparable)((Object)h2));
        this.dataset0.addValue(cc.getCountValue(), (Comparable)((Object)real_series), (Comparable)((Object)h2));
    }

    @Override
    public JFreeChart createChart(int nbr) {
        String title = this.getChartTitle() + ", Iteration: " + this.iteration_;
        this.chart_ = ChartFactory.createBarChart(title, "Hour", "Volumes [veh/h]", this.dataset0, PlotOrientation.VERTICAL, true, true, false);
        CategoryPlot plot = this.chart_.getCategoryPlot();
        plot.getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        BarRenderer renderer = new BarRenderer();
        renderer.setSeriesOutlinePaint(0, Color.black);
        renderer.setSeriesOutlinePaint(1, Color.black);
        renderer.setSeriesPaint(0, Color.getHSBColor(0.62f, 0.56f, 0.93f));
        renderer.setSeriesPaint(1, Color.getHSBColor(0.1f, 0.79f, 0.89f));
        renderer.setSeriesToolTipGenerator(0, new StandardCategoryToolTipGenerator());
        renderer.setSeriesToolTipGenerator(1, new StandardCategoryToolTipGenerator());
        renderer.setItemMargin(0.0);
        renderer.setShadowVisible(false);
        renderer.setBarPainter(new StandardBarPainter());
        this.chart_.setBackgroundPaint(Color.getHSBColor(0.0f, 0.0f, 0.93f));
        plot.setBackgroundPaint(Color.white);
        plot.setRangeGridlinePaint(Color.gray);
        plot.setRangeGridlinesVisible(true);
        plot.setRenderer(0, renderer);
        plot.setDomainAxisLocation(AxisLocation.BOTTOM_OR_RIGHT);
        plot.mapDatasetToRangeAxis(1, 1);
        CategoryAxis axis1 = plot.getDomainAxis();
        axis1.setCategoryMargin(0.25);
        return this.chart_;
    }

    public String getLinkId() {
        return this.linkId;
    }

    public void setLinkId(String linkId) {
        this.linkId = linkId;
    }
}

