/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.counts.algorithms.graphs;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.labels.CustomXYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.urls.CustomXYURLGenerator;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.matsim.counts.CountSimComparison;
import org.matsim.counts.algorithms.graphs.CountsGraph;
import org.matsim.counts.algorithms.graphs.helper.Comp;
import org.matsim.counts.algorithms.graphs.helper.MyComparator;

public final class CountsSimRealPerHourGraph
extends CountsGraph {
    private int hour;

    public CountsSimRealPerHourGraph(List<CountSimComparison> ccl, int iteration, String filename) {
        super(ccl, iteration, filename, filename);
    }

    @Override
    public JFreeChart createChart(int hour) {
        this.hour = hour;
        XYSeriesCollection dataset0 = new XYSeriesCollection();
        XYSeries series = new XYSeries((Comparable)((Object)"MATSim volumes"));
        XYSeriesCollection dataset_outliers = new XYSeriesCollection();
        XYSeries series_outliers = new XYSeries((Comparable)((Object)"MATSim outliers"));
        CustomXYURLGenerator url_gen = new CustomXYURLGenerator();
        CustomXYToolTipGenerator tt_gen = new CustomXYToolTipGenerator();
        ArrayList<String> urls = new ArrayList<String>();
        ArrayList<String> tooltips = new ArrayList<String>();
        Vector<Comp> comps = new Vector<Comp>();
        for (CountSimComparison cc : this.ccl_) {
            if (cc.getHour() != hour) continue;
            double realVal = 1.0;
            double simVal = 1.0;
            if (cc.getCountValue() > 0.0 && cc.getSimulationValue() > 0.0) {
                realVal = cc.getCountValue();
                simVal = cc.getSimulationValue();
                series.add(realVal, simVal);
                comps.add(new Comp(realVal, "link" + cc.getId() + ".html", "Link " + cc.getId() + "; " + "Count: " + realVal + ", Sim: " + simVal));
                continue;
            }
            realVal = Math.max(1.0, cc.getCountValue());
            simVal = Math.max(1.0, cc.getSimulationValue());
            series_outliers.add(realVal, simVal);
        }
        dataset0.addSeries(series);
        dataset_outliers.addSeries(series_outliers);
        Collections.sort(comps, new MyComparator());
        for (Comp cp : comps) {
            urls.add(cp.getURL());
            tooltips.add(cp.getTooltip());
        }
        url_gen.addURLSeries(urls);
        tt_gen.addToolTipSeries(tooltips);
        String title = "Volumes " + (hour - 1) + ":00 - " + hour + ":00, Iteration: " + this.iteration_;
        this.setChartTitle(title);
        this.chart_ = ChartFactory.createXYLineChart(title, "Count Volumes [veh/h]", "Sim Volumes [veh/h]", dataset0, PlotOrientation.VERTICAL, false, true, true);
        XYPlot plot = this.chart_.getXYPlot();
        LogarithmicAxis axis_x = new LogarithmicAxis("Count Volumes [veh/h]");
        LogarithmicAxis axis_y = new LogarithmicAxis("Sim Volumes [veh/h]");
        axis_x.setAllowNegativesFlag(false);
        axis_y.setAllowNegativesFlag(false);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setDefaultLinesVisible(false);
        renderer.setURLGenerator(url_gen);
        renderer.setSeriesPaint(0, Color.black);
        renderer.setSeriesToolTipGenerator(0, tt_gen);
        renderer.setSeriesShape(0, new Rectangle2D.Double(-1.5, -1.5, 3.0, 3.0));
        XYLineAndShapeRenderer renderer2 = new XYLineAndShapeRenderer();
        renderer2.setDefaultLinesVisible(false);
        renderer2.setSeriesPaint(0, Color.red);
        renderer2.setSeriesShape(0, new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0));
        DefaultXYDataset dataset1 = new DefaultXYDataset();
        dataset1.addSeries((Comparable)((Object)"f1x"), new double[][]{{1.0, 10000.0}, {1.0, 10000.0}});
        dataset1.addSeries((Comparable)((Object)"f2x"), new double[][]{{1.0, 10000.0}, {2.0, 20000.0}});
        dataset1.addSeries((Comparable)((Object)"f05x"), new double[][]{{2.0, 10000.0}, {1.0, 5000.0}});
        XYLineAndShapeRenderer renderer3 = new XYLineAndShapeRenderer();
        renderer3.setDefaultShapesVisible(false);
        renderer3.setSeriesPaint(0, Color.blue);
        renderer3.setSeriesPaint(1, Color.blue);
        renderer3.setSeriesPaint(2, Color.blue);
        renderer3.setDefaultSeriesVisibleInLegend(false);
        renderer3.setSeriesItemLabelsVisible(0, true);
        renderer3.setSeriesItemLabelsVisible(1, false);
        renderer3.setSeriesItemLabelsVisible(2, false);
        XYTextAnnotation annotation0 = new XYTextAnnotation("2.0 count", 12000.0, 15500.0);
        annotation0.setFont(new Font("SansSerif", 1, 11));
        plot.addAnnotation(annotation0);
        XYTextAnnotation annotation1 = new XYTextAnnotation("count", 13000.0, 10000.0);
        annotation1.setFont(new Font("SansSerif", 1, 11));
        plot.addAnnotation(annotation1);
        XYTextAnnotation annotation2 = new XYTextAnnotation("0.5 count", 11000.0, 3500.0);
        annotation2.setFont(new Font("SansSerif", 1, 11));
        plot.addAnnotation(annotation2);
        plot.setDomainAxis(axis_x);
        plot.setRangeAxis(axis_y);
        plot.setRenderer(0, renderer);
        plot.setRenderer(1, renderer2);
        plot.setDataset(1, dataset_outliers);
        plot.setRenderer(2, renderer3);
        plot.setDataset(2, dataset1);
        plot.getRangeAxis().setRange(1.0, 19000.0);
        plot.getDomainAxis().setRange(1.0, 19000.0);
        return this.chart_;
    }

    public int getHour() {
        return this.hour;
    }
}

