/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.deprecated.scoring.functions;

import org.apache.log4j.Logger;
import org.matsim.api.core.v01.events.ActivityEndEvent;
import org.matsim.api.core.v01.events.Event;
import org.matsim.api.core.v01.events.PersonDepartureEvent;
import org.matsim.api.core.v01.events.PersonEntersVehicleEvent;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Route;
import org.matsim.core.scoring.functions.ModeUtilityParameters;
import org.matsim.core.scoring.functions.ScoringParameters;
import org.matsim.deprecated.scoring.ScoringFunctionAccumulator;
import org.matsim.pt.transitSchedule.api.TransitSchedule;

@Deprecated
public class CharyparNagelLegScoring
implements ScoringFunctionAccumulator.LegScoring,
ScoringFunctionAccumulator.ArbitraryEventScoring {
    protected double score;
    private double lastTime;
    private static final double INITIAL_LAST_TIME = 0.0;
    private static final double INITIAL_SCORE = 0.0;
    protected final ScoringParameters params;
    private Leg currentLeg;
    protected Network network;
    private TransitSchedule transitSchedule;
    private boolean nextEnterVehicleIsFirstOfTrip = true;
    private boolean nextStartPtLegIsFirstOfTrip = true;
    private boolean currentLegIsPtLeg = false;
    private double lastActivityEndTime = Double.NEGATIVE_INFINITY;
    private static int ccc = 0;

    @Deprecated
    public CharyparNagelLegScoring(ScoringParameters params, Network network) {
        this.params = params;
        this.network = network;
        this.reset();
    }

    @Deprecated
    public CharyparNagelLegScoring(ScoringParameters params, Network network, TransitSchedule transitSchedule) {
        this(params, network);
        this.transitSchedule = transitSchedule;
    }

    @Override
    public void reset() {
        this.lastTime = 0.0;
        this.score = 0.0;
        this.nextEnterVehicleIsFirstOfTrip = true;
        this.nextStartPtLegIsFirstOfTrip = true;
        this.currentLegIsPtLeg = false;
    }

    @Override
    @Deprecated
    public void startLeg(double time, Leg leg) {
        assert (leg != null);
        this.lastTime = time;
        this.currentLeg = leg;
    }

    @Override
    @Deprecated
    public void endLeg(double time) {
        this.score += this.calcLegScore(this.lastTime, time, this.currentLeg);
        this.lastTime = time;
    }

    @Override
    public void finish() {
    }

    @Override
    public double getScore() {
        return this.score;
    }

    protected double calcLegScore(double departureTime, double arrivalTime, Leg leg) {
        double tmpScore = 0.0;
        double travelTime = arrivalTime - departureTime;
        ModeUtilityParameters modeParams = this.params.modeParams.get(leg.getMode());
        if (modeParams == null) {
            modeParams = leg.getMode().equals("transit_walk") ? this.params.modeParams.get("walk") : this.params.modeParams.get("other");
        }
        tmpScore += travelTime * modeParams.marginalUtilityOfTraveling_s;
        if (modeParams.marginalUtilityOfDistance_m != 0.0 || modeParams.monetaryDistanceCostRate != 0.0) {
            Route route = leg.getRoute();
            double dist = route.getDistance();
            if (Double.isNaN(dist) && ccc < 10) {
                Logger.getLogger(this.getClass()).warn("distance is NaN. Will make score of this plan NaN. Possible reason: Simulation does not report a distance for this trip. Possible reason for that: mode is teleported and router does not write distance into plan.  Needs to be fixed or these plans will die out.");
                if (++ccc == 10) {
                    Logger.getLogger(this.getClass()).warn(" Future occurences of this logging statement are suppressed.");
                }
            }
            tmpScore += modeParams.marginalUtilityOfDistance_m * dist;
            tmpScore += modeParams.monetaryDistanceCostRate * this.params.marginalUtilityOfMoney * dist;
        }
        return tmpScore += modeParams.constant;
    }

    @Override
    public void handleEvent(Event event) {
        if (event instanceof ActivityEndEvent) {
            if (!"pt interaction".equals(((ActivityEndEvent)event).getActType())) {
                this.nextEnterVehicleIsFirstOfTrip = true;
                this.nextStartPtLegIsFirstOfTrip = true;
            }
            this.lastActivityEndTime = event.getTime();
        }
        if (event instanceof PersonEntersVehicleEvent && this.currentLegIsPtLeg) {
            if (!this.nextEnterVehicleIsFirstOfTrip) {
                this.score += this.params.utilityOfLineSwitch;
            }
            this.nextEnterVehicleIsFirstOfTrip = false;
            this.score += (event.getTime() - this.lastActivityEndTime) * (this.params.marginalUtilityOfWaitingPt_s - this.params.modeParams.get((Object)"pt").marginalUtilityOfTraveling_s);
        }
        if (event instanceof PersonDepartureEvent) {
            this.currentLegIsPtLeg = "pt".equals(((PersonDepartureEvent)event).getLegMode());
            if (this.currentLegIsPtLeg) {
                if (!this.nextStartPtLegIsFirstOfTrip) {
                    this.score -= this.params.modeParams.get((Object)"pt").constant;
                }
                this.nextStartPtLegIsFirstOfTrip = false;
            }
        }
    }
}

