/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.facilities;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.core.utils.collections.QuadTree;
import org.matsim.facilities.ActivityFacilities;
import org.matsim.facilities.ActivityFacilitiesFactory;
import org.matsim.facilities.ActivityFacilitiesFactoryImpl;
import org.matsim.facilities.ActivityFacility;
import org.matsim.facilities.ActivityFacilityImpl;
import org.matsim.facilities.ActivityOption;
import org.matsim.facilities.SearchableActivityFacilities;
import org.matsim.utils.objectattributes.ObjectAttributes;
import org.matsim.utils.objectattributes.attributable.Attributes;

public class ActivityFacilitiesImpl
implements ActivityFacilities,
SearchableActivityFacilities {
    private long nextMsg = 1L;
    private static final Logger log = Logger.getLogger(ActivityFacilitiesImpl.class);
    private final ActivityFacilitiesFactory factory;
    private final Attributes attributes = new Attributes();
    private final Map<Id<ActivityFacility>, ActivityFacility> facilities = new LinkedHashMap<Id<ActivityFacility>, ActivityFacility>();
    private String name;
    private final ObjectAttributes facilityAttributes = new ObjectAttributes();
    private QuadTree<ActivityFacility> facilitiesQuadTree;

    @Deprecated
    public ActivityFacilitiesImpl(String name) {
        this.name = name;
        this.factory = new ActivityFacilitiesFactoryImpl();
    }

    @Deprecated
    public ActivityFacilitiesImpl() {
        this(null);
    }

    public final ActivityFacilityImpl createAndAddFacility(Id<ActivityFacility> id, Coord center) {
        return this.createAndAddFacility(id, center, null);
    }

    public final ActivityFacilityImpl createAndAddFacility(Id<ActivityFacility> id, Coord center, Id<Link> linkId) {
        if (this.facilities.containsKey(id)) {
            throw new IllegalArgumentException("Facility with id=" + id + " already exists.");
        }
        ActivityFacilityImpl f = new ActivityFacilityImpl(id, center, linkId);
        this.facilities.put(f.getId(), f);
        if ((long)this.facilities.size() % this.nextMsg == 0L) {
            this.nextMsg *= 2L;
            log.info("    facility # " + this.facilities.size());
        }
        return f;
    }

    @Override
    public ActivityFacilitiesFactory getFactory() {
        return this.factory;
    }

    @Override
    public final Map<Id<ActivityFacility>, ? extends ActivityFacility> getFacilities() {
        return this.facilities;
    }

    @Override
    public final TreeMap<Id<ActivityFacility>, ActivityFacility> getFacilitiesForActivityType(String act_type) {
        TreeMap<Id<ActivityFacility>, ActivityFacility> facs = new TreeMap<Id<ActivityFacility>, ActivityFacility>();
        for (ActivityFacility f : this.facilities.values()) {
            Map<String, ActivityOption> a = f.getActivityOptions();
            if (!a.containsKey(act_type)) continue;
            facs.put(f.getId(), f);
        }
        return facs;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public final void addActivityFacility(ActivityFacility facility) {
        if (this.facilities.containsKey(facility.getId())) {
            throw new IllegalArgumentException("Facility with id=" + facility.getId() + " already exists.");
        }
        this.facilities.put(facility.getId(), facility);
    }

    @Override
    public ObjectAttributes getFacilityAttributes() {
        return this.facilityAttributes;
    }

    public String toString() {
        StringBuilder stb = new StringBuilder(200);
        stb.append(super.toString());
        stb.append("\n");
        stb.append("[number of facilities=");
        stb.append(this.facilities.size());
        stb.append("]\n");
        for (Map.Entry<Id<ActivityFacility>, ActivityFacility> entry : this.facilities.entrySet()) {
            ActivityFacility fac = entry.getValue();
            stb.append("[key=");
            stb.append(entry.getKey().toString());
            stb.append("; value=");
            stb.append(fac.toString());
            stb.append("]\n");
        }
        return stb.toString();
    }

    private synchronized void buildQuadTree() {
        if (this.facilitiesQuadTree != null) {
            return;
        }
        double startTime = System.currentTimeMillis();
        double minx = Double.POSITIVE_INFINITY;
        double miny = Double.POSITIVE_INFINITY;
        double maxx = Double.NEGATIVE_INFINITY;
        double maxy = Double.NEGATIVE_INFINITY;
        for (ActivityFacility n : this.facilities.values()) {
            if (n.getCoord().getX() < minx) {
                minx = n.getCoord().getX();
            }
            if (n.getCoord().getY() < miny) {
                miny = n.getCoord().getY();
            }
            if (n.getCoord().getX() > maxx) {
                maxx = n.getCoord().getX();
            }
            if (!(n.getCoord().getY() > maxy)) continue;
            maxy = n.getCoord().getY();
        }
        log.info("building QuadTree for nodes: xrange(" + (minx -= 1.0) + "," + (maxx += 1.0) + "); yrange(" + (miny -= 1.0) + "," + (maxy += 1.0) + ")");
        QuadTree<ActivityFacility> quadTree = new QuadTree<ActivityFacility>(minx, miny, maxx, maxy);
        for (ActivityFacility n : this.facilities.values()) {
            quadTree.put(n.getCoord().getX(), n.getCoord().getY(), n);
        }
        this.facilitiesQuadTree = quadTree;
        log.info("Building QuadTree took " + ((double)System.currentTimeMillis() - startTime) / 1000.0 + " seconds.");
    }

    @Override
    public ActivityFacility getNearestFacility(Coord coord) {
        if (this.facilitiesQuadTree == null) {
            this.buildQuadTree();
        }
        return this.facilitiesQuadTree.getClosest(coord.getX(), coord.getY());
    }

    @Override
    public Collection<ActivityFacility> getNearestFacilities(Coord coord, double distance) {
        if (this.facilitiesQuadTree == null) {
            this.buildQuadTree();
        }
        return this.facilitiesQuadTree.getDisk(coord.getX(), coord.getY(), distance);
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }
}

