/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.facilities;

import java.util.Map;
import java.util.TreeMap;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Customizable;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.core.api.internal.MatsimDataClassImplMarkerInterface;
import org.matsim.core.scenario.CustomizableUtils;
import org.matsim.core.scenario.Lockable;
import org.matsim.core.utils.geometry.CoordUtils;
import org.matsim.facilities.ActivityFacility;
import org.matsim.facilities.ActivityOption;
import org.matsim.facilities.ActivityOptionImpl;
import org.matsim.utils.objectattributes.attributable.Attributes;

public class ActivityFacilityImpl
implements ActivityFacility,
MatsimDataClassImplMarkerInterface,
Lockable {
    private Customizable customizableDelegate;
    private final Map<String, ActivityOption> activities = new TreeMap<String, ActivityOption>();
    private String desc = null;
    private Coord coord;
    private Id<ActivityFacility> id;
    private Id<Link> linkId;
    private boolean locked = false;
    private final Attributes attributes = new Attributes();

    protected ActivityFacilityImpl(Id<ActivityFacility> id, Coord center, Id<Link> linkId) {
        this.id = id;
        this.coord = center;
        this.linkId = linkId;
    }

    public final double calcDistance(Coord otherCoord) {
        return CoordUtils.calcEuclideanDistance(this.coord, otherCoord);
    }

    public final ActivityOptionImpl createAndAddActivityOption(String type) {
        String type2 = type.intern();
        ActivityOptionImpl a = new ActivityOptionImpl(type2);
        this.addActivityOption(a);
        return a;
    }

    @Override
    public final void addActivityOption(ActivityOption option) {
        String type = option.getType();
        if (this.activities.containsKey(type)) {
            throw new RuntimeException(this + "[type=" + type + " already exists]");
        }
        this.activities.put(type, option);
    }

    @Override
    public final void setCoord(Coord newCoord) {
        this.testForLocked();
        this.coord = newCoord;
    }

    public final void setDesc(String desc) {
        this.desc = desc == null ? null : desc.intern();
    }

    public final String getDesc() {
        return this.desc;
    }

    @Override
    public final Map<String, ActivityOption> getActivityOptions() {
        return this.activities;
    }

    @Override
    public final Id<Link> getLinkId() {
        return this.linkId;
    }

    public final void setLinkId(Id<Link> linkId) {
        this.linkId = linkId;
    }

    public final String toString() {
        return "[" + super.toString() + " ID=" + this.id + "| linkID=" + this.linkId + "| nof_activities=" + this.activities.size() + "]";
    }

    @Override
    public final Coord getCoord() {
        return this.coord;
    }

    @Override
    public final Id<ActivityFacility> getId() {
        return this.id;
    }

    @Override
    public final Map<String, Object> getCustomAttributes() {
        if (this.customizableDelegate == null) {
            this.customizableDelegate = CustomizableUtils.createCustomizable();
        }
        return this.customizableDelegate.getCustomAttributes();
    }

    @Override
    public void setLocked() {
        this.locked = true;
    }

    private void testForLocked() {
        if (this.locked) {
            throw new RuntimeException("too late to do this");
        }
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }
}

