/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.facilities;

import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import org.matsim.facilities.ActivityOption;
import org.matsim.facilities.OpeningTime;

public class ActivityOptionImpl
implements ActivityOption {
    private final String type;
    private Double capacity = 2.147483647E9;
    private SortedSet<OpeningTime> openingTimes = new TreeSet<OpeningTime>();

    public ActivityOptionImpl(String type) {
        this.type = type;
    }

    public void clearOpeningTimes() {
        this.openingTimes.clear();
    }

    @Override
    public void addOpeningTime(OpeningTime opentime) {
        if (this.openingTimes.isEmpty()) {
            this.openingTimes.add(opentime);
            return;
        }
        TreeSet<OpeningTime> new_o_set = new TreeSet<OpeningTime>();
        for (OpeningTime o : this.openingTimes) {
            int merge_type = o.compareTo(opentime);
            if (merge_type == -6 || merge_type == 6) {
                new_o_set.add(o);
                new_o_set.add(opentime);
                continue;
            }
            if (merge_type >= -1 && merge_type <= 2) {
                new_o_set.add(o);
                continue;
            }
            if (merge_type == -3 || merge_type == -2 || merge_type == 3) {
                new_o_set.add(opentime);
                continue;
            }
            if (merge_type == -5 || merge_type == -4) {
                opentime.setEndTime(o.getEndTime());
                new_o_set.add(opentime);
                continue;
            }
            if (merge_type == 4 || merge_type == 5) {
                opentime.setStartTime(o.getStartTime());
                new_o_set.add(opentime);
                continue;
            }
            throw new RuntimeException("[Something is wrong]");
        }
        this.openingTimes.clear();
        this.openingTimes.addAll(new_o_set);
    }

    public void setOpeningTimes(Collection<OpeningTime> times) {
        this.clearOpeningTimes();
        for (OpeningTime t : times) {
            this.addOpeningTime(t);
        }
    }

    @Override
    public final void setCapacity(double capacity) {
        if (capacity < 0.0) {
            throw new NumberFormatException("A capacity of an activity must be >= 0.");
        }
        this.capacity = capacity;
    }

    @Override
    public final String getType() {
        return this.type;
    }

    @Override
    public final double getCapacity() {
        return this.capacity;
    }

    @Override
    public final SortedSet<OpeningTime> getOpeningTimes() {
        return this.openingTimes;
    }

    public final String toString() {
        return "[type=" + this.type + "]" + "[capacity=" + this.capacity + "]" + "[nof_opentimes=" + this.getOpeningTimes().size() + "]";
    }
}

