/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.facilities;

import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.api.core.v01.population.Population;
import org.matsim.core.config.groups.FacilitiesConfigGroup;
import org.matsim.core.config.groups.PlanCalcScoreConfigGroup;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.network.NetworkUtils;
import org.matsim.facilities.ActivityFacilities;
import org.matsim.facilities.ActivityFacilitiesFactory;
import org.matsim.facilities.ActivityFacility;
import org.matsim.facilities.ActivityOption;
import org.matsim.facilities.OpeningTimeImpl;

public final class FacilitiesFromPopulation {
    private static final Logger log = Logger.getLogger(FacilitiesFromPopulation.class);
    private final ActivityFacilities facilities;
    private boolean oneFacilityPerLink;
    private String idPrefix = "";
    private Network network = null;
    private boolean removeLinksAndCoordinates = true;
    private PlanCalcScoreConfigGroup planCalcScoreConfigGroup = null;
    private boolean addEmptyActivityOptions = false;

    public FacilitiesFromPopulation(ActivityFacilities facilities) {
        this.facilities = facilities;
    }

    public FacilitiesFromPopulation(Scenario scenario) {
        this(scenario.getActivityFacilities());
        FacilitiesConfigGroup facilityConfigGroup = scenario.getConfig().facilities();
        this.idPrefix = facilityConfigGroup.getIdPrefix();
        this.removeLinksAndCoordinates = false;
        this.addEmptyActivityOptions = true;
        if (facilityConfigGroup.getFacilitiesSource() == FacilitiesConfigGroup.FacilitiesSource.onePerActivityLinkInPlansFile) {
            this.oneFacilityPerLink = true;
        } else if (facilityConfigGroup.getFacilitiesSource() == FacilitiesConfigGroup.FacilitiesSource.onePerActivityLocationInPlansFile) {
            this.oneFacilityPerLink = false;
        } else {
            throw new RuntimeException("invalid");
        }
        this.network = scenario.getNetwork();
        this.planCalcScoreConfigGroup = scenario.getConfig().planCalcScore();
    }

    public void setOneFacilityPerLink(boolean oneFacilityPerLink) {
        this.oneFacilityPerLink = oneFacilityPerLink;
    }

    public void setIdPrefix(String prefix) {
        this.idPrefix = prefix;
    }

    public void setAssignLinksToFacilitiesIfMissing(Network network) {
        Gbl.assertNotNull(network);
        this.network = network;
    }

    public void setRemoveLinksAndCoordinates(boolean doRemoval) {
        this.removeLinksAndCoordinates = doRemoval;
    }

    public void assignOpeningTimes(PlanCalcScoreConfigGroup calcScoreConfigGroup) {
        Gbl.assertNotNull(calcScoreConfigGroup);
        this.planCalcScoreConfigGroup = calcScoreConfigGroup;
    }

    public void run(Population population) {
        this.handleActivities(population);
        if (this.planCalcScoreConfigGroup != null) {
            if (this.addEmptyActivityOptions) {
                this.assignOpeningTimes();
            } else {
                log.error("Cannot assign opening times to activity facilities because switch to add empty activity option to activity facilities is set to false.");
            }
        }
    }

    private void handleActivities(Population population) {
        int idxCounter = 0;
        ActivityFacilitiesFactory factory = this.facilities.getFactory();
        HashMap<Id<Link>, ActivityFacility> facilitiesPerLinkId = new HashMap<Id<Link>, ActivityFacility>();
        HashMap<Coord, ActivityFacility> facilitiesPerCoordinate = new HashMap<Coord, ActivityFacility>();
        for (Person person : population.getPersons().values()) {
            for (Plan plan : person.getPlans()) {
                for (PlanElement pe : plan.getPlanElements()) {
                    if (!(pe instanceof Activity)) continue;
                    Activity a = (Activity)pe;
                    Coord c = a.getCoord();
                    Id<Link> linkId = a.getLinkId();
                    ActivityFacility facility = null;
                    Gbl.assertNotNull(this.network);
                    if (linkId == null && this.network != null) {
                        linkId = NetworkUtils.getNearestLinkExactly(this.network, c).getId();
                    }
                    Gbl.assertNotNull(linkId);
                    if (this.oneFacilityPerLink && linkId != null) {
                        facility = (ActivityFacility)facilitiesPerLinkId.get(linkId);
                        if (facility == null) {
                            facility = factory.createActivityFacility(Id.create(this.idPrefix + linkId.toString(), ActivityFacility.class), c, linkId);
                            this.facilities.addActivityFacility(facility);
                            facilitiesPerLinkId.put(linkId, facility);
                        }
                    } else {
                        if (c == null) {
                            throw new RuntimeException("Coordinate for the activity " + a + " is null, cannot collect facilities per coordinate. " + "Probably, use " + (Object)((Object)FacilitiesConfigGroup.FacilitiesSource.onePerActivityLinkInPlansFile) + " instead and collect facilities per link.");
                        }
                        facility = (ActivityFacility)facilitiesPerCoordinate.get(c);
                        if (facility == null) {
                            facility = factory.createActivityFacility(Id.create(this.idPrefix + idxCounter++, ActivityFacility.class), c, linkId);
                            this.facilities.addActivityFacility(facility);
                            facilitiesPerCoordinate.put(c, facility);
                        }
                    }
                    if (this.addEmptyActivityOptions) {
                        String actType = a.getType();
                        ActivityOption option = facility.getActivityOptions().get(actType);
                        if (option == null) {
                            option = factory.createActivityOption(actType);
                            facility.addActivityOption(option);
                        }
                    }
                    a.setFacilityId(facility.getId());
                    if (!this.removeLinksAndCoordinates) continue;
                    a.setLinkId(null);
                    a.setCoord(null);
                }
            }
        }
    }

    private void assignOpeningTimes() {
        HashSet<String> missingActTypes = new HashSet<String>();
        for (ActivityFacility activityFacility : this.facilities.getFacilities().values()) {
            for (ActivityOption ao : activityFacility.getActivityOptions().values()) {
                String actType = ao.getType();
                PlanCalcScoreConfigGroup.ActivityParams params = this.planCalcScoreConfigGroup.getActivityParams(actType);
                if (params == null) {
                    if (!missingActTypes.add(actType)) continue;
                    log.error("No information for activity type " + actType + " found in given configuration.");
                    continue;
                }
                ao.addOpeningTime(new OpeningTimeImpl(params.getOpeningTime(), params.getClosingTime()));
            }
        }
    }

    public void setAddEmptyActivityOptions(boolean addEmptyActivityOptions) {
        this.addEmptyActivityOptions = addEmptyActivityOptions;
    }
}

