/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.facilities;

import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.core.scenario.ProjectionUtils;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.geometry.transformations.IdentityTransformation;
import org.matsim.core.utils.geometry.transformations.TransformationFactory;
import org.matsim.core.utils.io.MatsimXmlParser;
import org.matsim.core.utils.misc.Time;
import org.matsim.facilities.ActivityFacilities;
import org.matsim.facilities.ActivityFacilitiesFactory;
import org.matsim.facilities.ActivityFacility;
import org.matsim.facilities.ActivityFacilityImpl;
import org.matsim.facilities.ActivityOption;
import org.matsim.facilities.OpeningTimeImpl;
import org.matsim.utils.objectattributes.AttributeConverter;
import org.matsim.utils.objectattributes.attributable.Attributes;
import org.matsim.utils.objectattributes.attributable.AttributesXmlReaderDelegate;

final class FacilitiesReaderMatsimV1
extends MatsimXmlParser {
    private static Logger log = Logger.getLogger(FacilitiesReaderMatsimV1.class);
    private static final String FACILITIES = "facilities";
    private static final String FACILITY = "facility";
    private static final String ACTIVITY = "activity";
    private static final String CAPACITY = "capacity";
    private static final String OPENTIME = "opentime";
    private static final String ATTRIBUTES = "attributes";
    private static final String ATTRIBUTE = "attribute";
    private final ActivityFacilities facilities;
    private final ActivityFacilitiesFactory factory;
    private final AttributesXmlReaderDelegate attributesReader = new AttributesXmlReaderDelegate();
    private ActivityFacility currfacility = null;
    private ActivityOption curractivity = null;
    private Attributes currAttributes = null;
    private final String externalInputCRS;
    private final String targetCRS;
    private CoordinateTransformation coordinateTransformation = new IdentityTransformation();

    FacilitiesReaderMatsimV1(String externalInputCRS, String targetCRS, ActivityFacilities facilities) {
        this.externalInputCRS = externalInputCRS;
        this.targetCRS = targetCRS;
        this.facilities = facilities;
        this.factory = this.facilities.getFactory();
        if (externalInputCRS != null && targetCRS != null) {
            this.coordinateTransformation = TransformationFactory.getCoordinateTransformation(externalInputCRS, targetCRS);
            ProjectionUtils.putCRS(this.facilities, targetCRS);
        }
    }

    public void putAttributeConverter(Class<?> clazz, AttributeConverter<?> converter) {
        this.attributesReader.putAttributeConverter(clazz, converter);
    }

    public void putAttributeConverters(Map<Class<?>, AttributeConverter<?>> converters) {
        this.attributesReader.putAttributeConverters(converters);
    }

    @Override
    public void startTag(String name, org.xml.sax.Attributes atts, Stack<String> context) {
        if (FACILITIES.equals(name)) {
            this.startFacilities(atts);
        } else if (FACILITY.equals(name)) {
            this.startFacility(atts);
        } else if (ACTIVITY.equals(name)) {
            this.startActivity(atts);
        } else if (CAPACITY.equals(name)) {
            this.startCapacity(atts);
        } else if (OPENTIME.equals(name)) {
            this.startOpentime(atts);
        } else if (ATTRIBUTE.equals(name)) {
            this.attributesReader.startTag(name, atts, context, this.currAttributes);
        } else if (ATTRIBUTES.equals(name)) {
            this.currAttributes = context.peek().equals(FACILITIES) ? this.facilities.getAttributes() : this.currfacility.getAttributes();
            this.attributesReader.startTag(name, atts, context, this.currAttributes);
        }
    }

    @Override
    public void endTag(String name, String content, Stack<String> context) {
        if (FACILITY.equals(name)) {
            this.currfacility = null;
        } else if (ACTIVITY.equals(name)) {
            this.curractivity = null;
        } else if (ATTRIBUTES.equalsIgnoreCase(name)) {
            String inputCRS;
            if (context.peek().equals(FACILITIES) && (inputCRS = (String)this.currAttributes.getAttribute("coordinateReferenceSystem")) != null && this.targetCRS != null) {
                if (this.externalInputCRS != null) {
                    log.warn("coordinate transformation defined both in config and in input file: setting from input file will be used");
                }
                this.coordinateTransformation = TransformationFactory.getCoordinateTransformation(inputCRS, this.targetCRS);
                this.currAttributes.putAttribute("coordinateReferenceSystem", this.targetCRS);
            }
            this.currAttributes = null;
        } else if (ATTRIBUTE.equalsIgnoreCase(name)) {
            this.attributesReader.endTag(name, content, context);
        }
    }

    private void startFacilities(org.xml.sax.Attributes atts) {
        this.facilities.setName(atts.getValue("name"));
        this.currAttributes = this.facilities.getAttributes();
        if (atts.getValue("aggregation_layer") != null) {
            Logger.getLogger(FacilitiesReaderMatsimV1.class).warn("aggregation_layer is deprecated.");
        }
    }

    private void startFacility(org.xml.sax.Attributes atts) {
        if (atts.getValue("x") != null && atts.getValue("y") != null) {
            this.currfacility = atts.getValue("linkId") != null ? this.factory.createActivityFacility(Id.create(atts.getValue("id"), ActivityFacility.class), this.coordinateTransformation.transform(new Coord(Double.parseDouble(atts.getValue("x")), Double.parseDouble(atts.getValue("y")))), Id.create(atts.getValue("linkId"), Link.class)) : this.factory.createActivityFacility(Id.create(atts.getValue("id"), ActivityFacility.class), this.coordinateTransformation.transform(new Coord(Double.parseDouble(atts.getValue("x")), Double.parseDouble(atts.getValue("y")))));
        } else if (atts.getValue("linkId") != null) {
            this.currfacility = this.factory.createActivityFacility(Id.create(atts.getValue("id"), ActivityFacility.class), Id.create(atts.getValue("linkId"), Link.class));
        } else {
            throw new RuntimeException("Neither coordinate nor linkId are available for facility id " + atts.getValue("id") + ". Aborting....");
        }
        this.facilities.addActivityFacility(this.currfacility);
        ((ActivityFacilityImpl)this.currfacility).setDesc(atts.getValue("desc"));
    }

    private void startActivity(org.xml.sax.Attributes atts) {
        this.curractivity = this.factory.createActivityOption(atts.getValue("type"));
        this.currfacility.addActivityOption(this.curractivity);
    }

    private void startCapacity(org.xml.sax.Attributes atts) {
        double cap = Double.parseDouble(atts.getValue("value"));
        this.curractivity.setCapacity(cap);
    }

    private void startOpentime(org.xml.sax.Attributes atts) {
        this.curractivity.addOpeningTime(new OpeningTimeImpl(Time.parseTime(atts.getValue("start_time")), Time.parseTime(atts.getValue("end_time"))));
    }
}

